package se.gory_moon.chargers.handler;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.compat.Baubles;
import se.gory_moon.chargers.lib.ModInfo;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

import java.util.HashMap;
import java.util.Map;

@Mod.EventBusSubscriber(modid = ModInfo.MODID)
public class WirelessHandler {

    public static WirelessHandler INSTANCE = new WirelessHandler();
    private Map<Integer, Map<BlockPos, TileEntityWirelessCharger>> dimensionChargers = new HashMap<>();

    public void register(TileEntityWirelessCharger charger) {
        Map<BlockPos, TileEntityWirelessCharger> chargers = getDimensionChargers(charger.func_145831_w());
        chargers.put(charger.func_174877_v(), charger);
    }

    public void unRegister(TileEntityWirelessCharger charger) {
        Map<BlockPos, TileEntityWirelessCharger> chargers = getDimensionChargers(charger.func_145831_w());
        chargers.remove(charger.func_174877_v());
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase != TickEvent.Phase.END || event.player.func_175149_v()) {
            return;
        }
        INSTANCE.chargeItems(event.player);
    }

    public void chargeItems(EntityPlayer player) {
        Map<BlockPos, TileEntityWirelessCharger> chargers = getDimensionChargers(player.field_70170_p);
        if (chargers.isEmpty()) return;

        BlockPos playerPos = player.func_180425_c();
        for (TileEntityWirelessCharger charger: chargers.values()) {
            if (charger.canCharge() && inRange(charger.func_174877_v(), playerPos)) {
                if (chargeItems(player, charger))
                    return;
            }
        }
    }

    private boolean chargeItems(EntityPlayer player, TileEntityWirelessCharger charger) {
        boolean result = charger.chargeItems(player.field_71071_by.field_70460_b);
        result |= charger.chargeItems(player.field_71071_by.field_70462_a);
        result |= charger.chargeItems(player.field_71071_by.field_184439_c);
        result |= Baubles.INSTANCE.chargeItems(player, charger);
        if (result)
            player.field_71069_bz.func_75142_b();
        return result;
    }

    private boolean inRange(BlockPos a, BlockPos b) {
        int range = Configs.chargers.wireless.wirelessRange;
        int dx = a.func_177958_n() - b.func_177958_n();
        if (dx > range || dx < -range) return false;
        int dz = a.func_177952_p() - b.func_177952_p();
        if (dz > range || dz < -range) return false;
        int dy = a.func_177956_o() - b.func_177956_o();
        return (dx * dx + dy * dy + dz * dz) <= (range * range);
    }

    private Map<BlockPos, TileEntityWirelessCharger> getDimensionChargers(World world) {
        return dimensionChargers.computeIfAbsent(world.field_73011_w.getDimension(), integer -> new HashMap<>());
    }
}
