/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.items;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.gory_moon.chargers.ChargersMod;
import se.gory_moon.chargers.blocks.BlockRegistry;

@Mod.EventBusSubscriber
public class ItemRegistry {
    public static final Set<Item> ITEMS = new LinkedHashSet<Item>();

    public static void preInit() {
        try {
            for (Field field : ItemRegistry.class.getDeclaredFields()) {
                if (!(field.get(null) instanceof Item)) continue;
                Item item = (Item)field.get(null);
                ItemRegistry.registerItem(item, field.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void registerItem(Item item, String fieldName) {
        ITEMS.add(item);
        String name = fieldName.toLowerCase(Locale.ENGLISH);
        ((Item)item.setRegistryName("chargers", name)).setTranslationKey("chargers." + name);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Item item : BlockRegistry.ITEM_BLOCKS) {
            registry.register((IForgeRegistryEntry)item);
        }
        for (Item item : ITEMS) {
            registry.register((IForgeRegistryEntry)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : ITEMS) {
            ChargersMod.proxy.registerDefaultItemRenderer(item);
        }
    }

    public static interface IMultipleItemModelDefinition {
        @SideOnly(value=Side.CLIENT)
        public Map<Integer, ResourceLocation> getModels();
    }
}

