package se.gory_moon.chargers.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import se.gory_moon.chargers.compat.Baubles;
import se.gory_moon.chargers.network.PacketHandler;
import se.gory_moon.chargers.tile.TileEntityCharger;

public class ContainerCharger extends Container {

    private static final EntityEquipmentSlot[] EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    private TileEntityCharger tileCharger;
    public IItemHandler baubles;

    public ContainerCharger(EntityPlayer player, TileEntityCharger tile) {
        InventoryPlayer inventory = player.field_71071_by;
        tileCharger = tile;
        baubles = Baubles.getBaubles(player);

        int baublesOffset = baubles != null ? 9: 0;
        func_75146_a(new SlotInput(tile.inventoryHandler, 0, 70 - baublesOffset, 29));
        func_75146_a(new SlotOutput(tile.inventoryHandler, 1, 70 - baublesOffset, 62));

        int i;
        for (i = 0; i < 3; ++i)
            for (int j = 0; j < 9; ++j)
                func_75146_a(new Slot(inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));

        for (i = 0; i < 9; ++i)
            func_75146_a(new Slot(inventory, i, 8 + i * 18, 142));

        for(i = 0; i < 4; ++i) {
            final EntityEquipmentSlot slot = EQUIPMENT_SLOTS[i];
            func_75146_a(new Slot(inventory, 36 + (3 - i), 92 - baublesOffset, 8 + i * 18) {
                @Override
                public int func_75219_a() {
                    return 1;
                }

                @Override
                public boolean func_75214_a(ItemStack stack) {
                    return !stack.func_190926_b() && stack.func_77973_b().isValidArmor(stack, slot, player);
                }

                @SideOnly(Side.CLIENT)
                @Override
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[slot.func_188454_b()];
                }
            });
        }
        func_75146_a(new Slot(inventory, 40, 112 + baublesOffset, 62) {
            @SideOnly(Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });

        if (baubles != null) {
            for (i = 0; i < 7; i++) {
                func_75146_a(Baubles.getSlot(player, baubles, i, 103 + (i / 4) * 18, 8 + (i % 4) * 18));
            }
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();

        PacketHandler.sendToListeningPlayers(field_75149_d, tileCharger.func_189518_D_());
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = field_75151_b.get(index);

        int inventoryStart = 2;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        int armorStart = hotbarEnd + 1;
        int armorEnd = armorStart + 3;
        int offhand = armorEnd + 1;
        int baublesStart = offhand + 1;
        int baublesEnd = baublesStart + 6;

        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();

            if (index == 1 || index == 0) {
                if (Baubles.isLoaded() && (!func_75135_a(stack, baublesStart, baublesEnd, false) && !func_75135_a(stack, inventoryStart, armorEnd + 1, true)))
                    return ItemStack.field_190927_a;
                else if (!Baubles.isLoaded() && !func_75135_a(stack, inventoryStart, armorEnd + 1, true))
                    return ItemStack.field_190927_a;
                slot.func_75220_a(stack, itemstack);
            } else {
                if (!tileCharger.inventoryHandler.isItemValid(0, stack)) {
                    if (index <= inventoryEnd) {
                        if (!func_75135_a(stack, hotbarStart, hotbarEnd + 1, false))
                            return ItemStack.field_190927_a;
                    } else if (index < hotbarEnd + 1 && !func_75135_a(stack, inventoryStart, inventoryEnd + 1, false))
                        return ItemStack.field_190927_a;
                } else if (!func_75135_a(stack, 0, 1, false))
                    return ItemStack.field_190927_a;
            }

            if (stack.func_190916_E() == 0)
                slot.func_75215_d(ItemStack.field_190927_a);
            else
                slot.func_75218_e();

            if (stack.func_190916_E() == itemstack.func_190916_E())
                return ItemStack.field_190927_a;

            slot.func_190901_a(player, stack);
        }
        return itemstack;
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return player.func_70092_e((double) tileCharger.func_174877_v().func_177958_n() + 0.5D, (double) tileCharger.func_174877_v().func_177956_o() + 0.5D, (double) tileCharger.func_174877_v().func_177952_p() + 0.5D) <= 64.0D;
    }
}
