/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules;

import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import se.gory_moon.globalgamerules.GlobalGR;
import se.gory_moon.globalgamerules.config.GGRConfig;
import se.gory_moon.globalgamerules.reference.Reference;

@Mod.EventBusSubscriber(modid="globalgamerules")
public class WorldEvents {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules gRules = world.func_82736_K();
        Reference.logger.info("Applying config gamerules to dimension {} ({})", (Object)world.field_73011_w.getDimension(), (Object)info.func_76065_j());
        GlobalGR.getConfig().rules.forEach((s, value) -> gRules.func_82764_b(s, value.getStringValue()));
        if (!event.getWorld().field_72995_K && !info.func_176123_z()) {
            int diff = GlobalGR.getConfig().misc.get("worldDifficulty").getIntegerValue();
            if (diff != -1) {
                info.func_176144_a(EnumDifficulty.func_151523_a((int)diff));
                Reference.logger.info("Setting difficulty of dimension {} ({}) to {}", (Object)world.field_73011_w.getDimension(), (Object)info.func_76065_j(), (Object)EnumDifficulty.func_151523_a((int)diff).toString());
            }
            if (GlobalGR.getConfig().misc.get("worldDifficultyLocked").getBooleanValue()) {
                info.func_180783_e(true);
                Reference.logger.info("Locking difficulty of dimension {} ({})", (Object)world.field_73011_w.getDimension(), (Object)info.func_76065_j());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnLoad(WorldEvent.Unload event) {
        World world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules gRules = event.getWorld().func_82736_K();
        Reference.logger.info("Saving gamerules of dimension {} ({}) to config", (Object)world.field_73011_w.getDimension(), (Object)info.func_76065_j());
        GlobalGR.getConfig().rules.forEach((s, value) -> GlobalGR.getConfig().rules.put((String)s, new GGRConfig.Value(gRules.func_82767_a(s), value.getType())));
        if (!event.getWorld().field_72995_K && GlobalGR.getConfig().misc.get("worldDifficulty").getIntegerValue() != -1 && !event.getWorld().func_72912_H().func_176123_z()) {
            GGRConfig.Value val = GlobalGR.getConfig().misc.get("worldDifficulty");
            GGRConfig.Value newVal = new GGRConfig.Value(String.valueOf(info.func_176130_y().func_151525_a()), val.getType(), val.getShowInGui());
            GlobalGR.getConfig().misc.put("worldDifficulty", newVal);
        }
        GlobalGR.getConfig().saveConfig();
    }
}

