/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GGRConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec commonSpec;
    private static final HashMap<GameRules.RuleKey<?>, String> COMMENTS;

    static {
        COMMENTS = new HashMap();
        COMMENTS.put(GameRules.field_223598_a, "Whether fire should spread and naturally extinguish");
        COMMENTS.put(GameRules.field_223599_b, "Whether creepers, zombies, endermen, ghasts, withers, ender dragons, rabbits, sheep, villagers, and snow golems should be able to change blocks and whether mobs can pick up items. This also affects the capability of zombie-like creatures like zombie pigmen and drowned to pathfind to turtle eggs. This will also prevent villagers from breeding.");
        COMMENTS.put(GameRules.field_223600_c, "Whether the player should keep items in their inventory after death");
        COMMENTS.put(GameRules.field_223601_d, "Whether mobs should naturally spawn. Does not affect monster spawners.");
        COMMENTS.put(GameRules.field_223602_e, "Whether mobs should drop items");
        COMMENTS.put(GameRules.field_223603_f, "Whether blocks should have drops");
        COMMENTS.put(GameRules.field_223604_g, "Whether entities that are not mobs should have drops");
        COMMENTS.put(GameRules.field_223605_h, "Whether command blocks should notify admins when they perform commands\t");
        COMMENTS.put(GameRules.field_223606_i, "Whether the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as golden apples, the Regeneration effect, etc.)");
        COMMENTS.put(GameRules.field_223607_j, "Whether the day-night cycle and moon phases progress");
        COMMENTS.put(GameRules.field_223608_k, "Whether to log admin commands to server log");
        COMMENTS.put(GameRules.field_223609_l, "Whether death messages are put into chat when a player dies. Also affects whether a message is sent to the pet's owner when the pet dies.");
        COMMENTS.put(GameRules.field_223610_m, "How often a random block tick occurs (such as plant growth, leaf decay, etc.) per chunk section per game tick. 0 disables random ticks, higher numbers increase random ticks. Setting to a high integer results in high speeds of decay and growth");
        COMMENTS.put(GameRules.field_223611_n, "Whether the feedback from commands executed by a player should show up in chat. Also affects the default behavior of whether command blocks store their output text");
        COMMENTS.put(GameRules.field_223612_o, "Whether the debug screen shows all or reduced information; and whether the effects of F3+B (entity hitboxes) and F3+G (chunk boundaries) are shown.");
        COMMENTS.put(GameRules.field_223613_p, "Whether players in spectator mode can generate chunks");
        COMMENTS.put(GameRules.field_223614_q, "The number of blocks outward from the world spawn coordinates that a player spawns in when first joining a server or when dying without a personal spawnpoint.");
        COMMENTS.put(GameRules.field_223615_r, "Whether the server should skip checking player speed when the player is wearing elytra. Often helps with jittering due to lag in multiplayer, but may also be used to travel unfairly long distances in survival mode (cheating).");
        COMMENTS.put(GameRules.field_223616_s, "The maximum number of other pushable entities a mob or player can push, before taking 3 suffocation damage per half-second. Setting to 0 disables the rule. Damage affects survival-mode or adventure-mode players, and all mobs but bats. Pushable entities include non-spectator-mode players, any mob except bats, as well as boats and minecarts.");
        COMMENTS.put(GameRules.field_223617_t, "Whether the weather can change");
        COMMENTS.put(GameRules.field_223618_u, "Whether players should be able to craft only those recipes that they've unlocked first");
        COMMENTS.put(GameRules.field_223619_v, "Determines the number at which the chain command block acts as a \"chain\"");
        COMMENTS.put(GameRules.field_223620_w, "Whether advancements should be announced in chat");
        COMMENTS.put(GameRules.field_223621_x, "Whether raids are disabled.");
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)configSpecPair.getRight();
        COMMON = (Common)configSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue setDifficulty;
        public final ForgeConfigSpec.EnumValue<Difficulty> difficulty;
        public final ForgeConfigSpec.BooleanValue hardcore;
        public final ForgeConfigSpec.BooleanValue lockDifficulty;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> defaultCommands;
        public final ForgeConfigSpec.BooleanValue saveGameRules;
        public final Map<GameRules.RuleKey<?>, ForgeConfigSpec.ConfigValue<?>> gameRules;

        Common(final ForgeConfigSpec.Builder builder) {
            builder.comment("Common configs").push("common");
            builder.comment("Gamerules that are set when a world is loaded").push("gamerules");
            this.gameRules = new HashMap();
            final Converter converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
            GameRules.func_223590_a((GameRules.IRuleEntryVisitor)new GameRules.IRuleEntryVisitor(){

                public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> ruleKey, GameRules.RuleType<T> ruleType) {
                    GameRules.RuleValue t = ruleType.func_223579_a();
                    String name = (String)converter.convert((Object)ruleKey.func_223576_a());
                    if (name != null) {
                        if (t instanceof GameRules.BooleanValue) {
                            ForgeConfigSpec.BooleanValue value = builder.comment((String)COMMENTS.get(ruleKey)).define(name, ((GameRules.BooleanValue)t).func_223572_a());
                            gameRules.put(ruleKey, (ForgeConfigSpec.ConfigValue<?>)value);
                        } else if (t instanceof GameRules.IntegerValue) {
                            ForgeConfigSpec.IntValue value = builder.comment((String)COMMENTS.get(ruleKey)).defineInRange(name, ((GameRules.IntegerValue)t).func_223560_a(), 0, Integer.MAX_VALUE);
                            gameRules.put(ruleKey, (ForgeConfigSpec.ConfigValue<?>)value);
                        }
                    }
                }
            });
            builder.pop().comment("Configs related to difficult changes").push("difficulty");
            this.setDifficulty = builder.comment(new String[]{"If the difficulty should be set on world load", "If true difficulty changes in game will also be saved to the config"}).define("set_difficulty", false);
            this.difficulty = builder.comment("The difficulty to set if 'set_difficulty' is true, respects if the difficulty is locked or not for the world").defineEnum("difficulty", (Enum)Difficulty.NORMAL);
            this.hardcore = builder.comment(new String[]{"If true the world will be set to hardcore, difficultly will be set to hard independent to the 'difficulty' config", "Setting it to hardcore auto locks the difficulty while this is true"}).define("hardcore", false);
            this.lockDifficulty = builder.comment(new String[]{"If a world's difficulty should be locked when loaded, if world already is locked it can't be changed", "If the global world difficulty is enabled it's set first"}).define("lock_difficulty", false);
            builder.pop().comment("A collection of misc configs").push("misc");
            this.saveGameRules = builder.comment("If gamerules and world difficulty should be saved to config on world unload").define("save_gamerules", true);
            this.defaultCommands = builder.comment(new String[]{"A comma separated list of commands to run on world join, @p is replaced with joining player name, command is run by the server", "Example: default_commands = [\"/tellraw @p [\\\"\\\",{\\\"text\\\":\\\"Hi \\\"},{\\\"text\\\":\\\"@p\\\",\\\"color\\\":\\\"aqua\\\"}]\"]"}).defineList("default_commands", ArrayList::new, o -> !Strings.isNullOrEmpty((String)String.valueOf(o)) && String.valueOf(o).startsWith("/"));
            builder.pop(2);
        }
    }
}

