/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.UnlistedDirection;
import se.gory_moon.horsepower.client.renderer.ChopperModels;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Colors;
import se.gory_moon.horsepower.util.Localization;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockChopper
extends BlockHPBase
implements IProbeInfoAccessor {
    public static final UnlistedDirection FACING = new UnlistedDirection("facing");
    public static final PropertyDirection DIRECTION = PropertyDirection.create((String)"facing", Arrays.asList(EnumFacing.HORIZONTALS));
    public static final PropertyEnum<ChopperModels> PART = PropertyEnum.create((String)"part", ChopperModels.class);
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockChopper() {
        super(Material.WOOD);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setSoundType(SoundType.WOOD);
        this.setRegistryName("chopper");
        this.setUnlocalizedName("chopper");
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityChopper();
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasCustomBreakingProgress(IBlockState state) {
        return true;
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{PART, DIRECTION}, new IUnlistedProperty[]{FACING});
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityHPBase tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)FACING, (Object)tile.getForward()).withProperty((IProperty)DIRECTION, (Comparable)tile.getForward()).withProperty(PART, state.getValue(PART));
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, ((IExtendedBlockState)state).withProperty((IUnlistedProperty)FACING, (Object)placer.getHorizontalFacing().getOpposite()).withProperty((IProperty)DIRECTION, (Comparable)placer.getHorizontalFacing().getOpposite()), 2);
        TileEntityHPBase tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        tile.setForward(placer.getAdjustedHorizontalFacing().getOpposite());
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.SIZE.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.LOCATION.translate(new String[0]));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.USE.translate(new String[0]));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.getTileEntity(data.getPos());
        if (tileEntity instanceof TileEntityChopper) {
            TileEntityChopper te = (TileEntityChopper)tileEntity;
            double totalWindup = Configs.pointsForWindup > 0 ? (double)Configs.pointsForWindup : 1.0;
            probeInfo.progress((long)((double)te.getField(2) / totalWindup * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.WINDUP_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            if (te.getField(0) > 1) {
                probeInfo.progress((long)((double)te.getField(1) / (double)te.getField(0) * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.CHOPPING_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            }
        }
    }
}

