package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.GrindstoneRecipes;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.Utils;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TileEntityGrindstone extends TileEntity implements ITickable, ISidedInventory {

    private static final int[] SLOTS_TOP = new int[] {0};
    private static final int[] SLOTS_BOTTOM = new int[] {1};

    private NonNullList<ItemStack> millItemStacks = NonNullList.<ItemStack>func_191197_a(2, ItemStack.field_190927_a);

    private static double[][] path = {{-1.5, -1.5}, {0, -1.5}, {1, -1.5}, {1, 0}, {1, 1}, {0, 1}, {-1.5, 1}, {-1.5, 0}};
    private AxisAlignedBB[] searchAreas = new AxisAlignedBB[8];
    private List<BlockPos> searchPos = null;
    private int origin = -1;
    private int target = origin;

    private boolean hasWorker = false;
    private EntityCreature worker;
    private NBTTagCompound nbtWorker;

    private int currentItemMillTime;
    private int totalItemMillTime;
    private boolean running = true;
    private boolean wasRunning = false;

    private boolean valid = false;
    private int validationTimer = 0;

    public void setWorker(EntityCreature newWorker) {
        hasWorker = true;
        worker = newWorker;
        worker.func_175449_a(field_174879_c, 3);
        target = getClosestTarget();
    }

    public void setWorkerToPlayer(EntityPlayer player) {
        if (hasWorker() && worker.func_184652_a(player)) {
            hasWorker = false;
            worker.func_110177_bN();
            worker.func_110162_b(player, true);
            worker = null;
        }
    }

    public boolean hasWorker() {
        if (worker != null && !worker.field_70128_L && !worker.func_110167_bD() && worker.func_174818_b(field_174879_c) < 45) {
            return true;
        } else {
            if (worker != null) {
                worker = null;
                if (!func_145831_w().field_72995_K)
                    InventoryHelper.func_180173_a(field_145850_b, field_174879_c.func_177958_n(), field_174879_c.func_177956_o() + 1, field_174879_c.func_177952_p(), new ItemStack(Items.field_151058_ca));
            }
            hasWorker = false;
            return false;
        }
    }

    public EntityCreature getWorker() {
        return worker;
    }

    @Nullable
    @Override
    public ITextComponent func_145748_c_() {
        if (valid)
            return super.func_145748_c_();
        else
            return new TextComponentTranslation(Localization.INFO.GRINDSTONE_INVALID.key()).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a(compound, millItemStacks);
        compound.func_74768_a("millTime", currentItemMillTime);
        compound.func_74768_a("totalMillTime", totalItemMillTime);

        compound.func_74768_a("target", target);
        compound.func_74768_a("origin", origin);
        compound.func_74757_a("hasWorker", hasWorker);

        if (this.worker != null)
        {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            UUID uuid = worker.func_110124_au();
            nbtTagCompound.func_186854_a("UUID", uuid);

            compound.func_74782_a("leash", nbtTagCompound);
        }

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        millItemStacks = NonNullList.<ItemStack>func_191197_a(this.func_70302_i_(), ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b(compound, millItemStacks);

        if (func_70301_a(0).func_190916_E() > 0) {
            currentItemMillTime = compound.func_74762_e("millTime");
            totalItemMillTime = compound.func_74762_e("totalMillTime");
        } else {
            currentItemMillTime = 0;
            totalItemMillTime = 1;
        }

        target = compound.func_74762_e("target");
        origin = compound.func_74762_e("origin");
        hasWorker = compound.func_74767_n("hasWorker");

        if (hasWorker && compound.func_150297_b("leash", 10)) {
            nbtWorker = compound.func_74775_l("leash");
        }
    }

    public void notifyUpdate() {
        func_145831_w().func_184138_a(func_174877_v(), func_145831_w().func_180495_p(func_174877_v()), func_145831_w().func_180495_p(func_174877_v()), 3);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(func_174877_v(), -999, func_189517_E_());
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public void func_70296_d() {
        if (millItemStacks.get(1).func_190926_b())
            BlockGrindstone.setState(false, field_145850_b, field_174879_c);

        super.func_70296_d();
        notifyUpdate();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return func_189515_b(new NBTTagCompound());
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
       func_145839_a(tag);
       func_70296_d();
    }

    private boolean validateArea() {
        if (searchPos == null) {
            searchPos = Lists.newArrayList();

            for (int x = -3; x <= 3; x++) {
                for (int z = -3; z <= 3; z++) {
                    if (x == 0 && z == 0)
                        continue;
                    searchPos.add(func_174877_v().func_177982_a(x, 0, z));
                    searchPos.add(func_174877_v().func_177982_a(x, -1, z));
                }
            }
        }

        for (BlockPos pos: searchPos) {
            if (!func_145831_w().func_175623_d(pos))
                return false;
        }
        return true;
    }

    @Override
    public void func_73660_a() {
        boolean flag = false;

        validationTimer--;
        if (validationTimer <= 0) {
            valid = validateArea();
            if (valid)
                validationTimer = 220;
            else
                validationTimer = 60;
        }

        if (nbtWorker != null) {
            if (hasWorker) {
                UUID uuid = nbtWorker.func_186857_a("UUID");
                int x = field_174879_c.func_177958_n();
                int y = field_174879_c.func_177956_o();
                int z = field_174879_c.func_177952_p();

                ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
                search: for (Class<? extends Entity> clazz: clazzes) {
                    for (Object entity : field_145850_b.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0D, (double)y - 7.0D, (double)z - 7.0D, (double)x + 7.0D, (double)y + 7.0D, (double)z + 7.0D))){
                        if (entity instanceof EntityCreature) {
                            EntityCreature creature = (EntityCreature) entity;
                            if (creature.func_110124_au().equals(uuid)) {
                                setWorker(creature);
                                break search;
                            }
                        }
                    }
                }
            }
            nbtWorker = null;
        }

        if (!field_145850_b.field_72995_K && valid) {
            if (!running && canMill()) {
                running = true;
            } else if (running && !canMill()){
                running = false;
            }

            if (running != wasRunning) {
                target = getClosestTarget();
                wasRunning = running;
            }

            if (hasWorker()) {
                if (running) {

                    double x = field_174879_c.func_177958_n() + path[target][0] * 2;
                    double y = field_174879_c.func_177956_o() - 1;
                    double z = field_174879_c.func_177952_p() + path[target][1] * 2;

                    if (searchAreas[target] == null)
                        searchAreas[target] = new AxisAlignedBB(x - 0.5D, y - 0.5D, z - 0.5D, x + 0.5D, y + 0.5D, z + 0.5D);

                    if (worker.func_174813_aQ().func_72326_a(searchAreas[target])) {
                        int next = target + 1;
                        int previous = target -1;
                        if (next >= path.length)
                            next = 0;
                        if (previous < 0)
                            previous = path.length - 1;

                        if (origin != target && target != previous) {
                            origin = target;
                            currentItemMillTime++;

                            if (currentItemMillTime == totalItemMillTime) {
                                currentItemMillTime = 0;

                                totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime(millItemStacks.get(0));
                                millItem();
                                flag = true;
                            }
                        }
                        target = next;
                    }

                    if (worker instanceof AbstractHorse && ((AbstractHorse)worker).func_110204_cc()) {
                        ((AbstractHorse)worker).func_110227_p(false);
                    }

                    if (target != -1 && worker.func_70661_as().func_75500_f()) {
                        x = field_174879_c.func_177958_n() + path[target][0] * 2;
                        y = field_174879_c.func_177956_o() - 1;
                        z = field_174879_c.func_177952_p() + path[target][1] * 2;

                        worker.func_70661_as().func_75492_a(x, y, z, 1D);
                    }

                }
            }
        }

        if (flag) {
            func_70296_d();
        }
    }

    private int getClosestTarget() {
        if (hasWorker()) {
            double dist = Double.MAX_VALUE;
            int closest = 0;

            for (int i = 0; i < path.length; i++) {
                double x = field_174879_c.func_177958_n() + path[i][0] * 2;
                double y = field_174879_c.func_177956_o() - 1;
                double z = field_174879_c.func_177952_p() + path[i][1] * 2;

                double tmp = worker.func_70011_f(x, y, z);
                if (tmp < dist) {
                    dist = tmp;
                    closest = i;
                }
            }

            return closest;
        }
        return 0;
    }

    private void millItem() {
        if (canMill()) {
            ItemStack input = millItemStacks.get(0);
            ItemStack result = GrindstoneRecipes.instance().getGrindstoneResult(millItemStacks.get(0));
            ItemStack output = millItemStacks.get(1);

            if (output.func_190926_b())
            {
                millItemStacks.set(1, result.func_77946_l());
            }
            else if (output.func_77973_b() == result.func_77973_b())
            {
                output.func_190917_f(result.func_190916_E());
            }

            input.func_190918_g(1);
            BlockGrindstone.setState(true, field_145850_b, field_174879_c);
        }
    }

    private boolean canMill() {
        if (millItemStacks.get(0).func_190926_b()) {
            return false;
        } else {
            ItemStack itemstack = GrindstoneRecipes.instance().getGrindstoneResult(millItemStacks.get(0));

            if (itemstack.func_190926_b())
            {
                return false;
            }
            else
            {
                ItemStack output = millItemStacks.get(1);
                if (output.func_190926_b()) return true;
                if (!output.func_77969_a(itemstack)) return false;
                int result = output.func_190916_E() + itemstack.func_190916_E();
                return result <= func_70297_j_() && result <= output.func_77976_d();
            }
        }
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == stack2.func_77960_j() && (stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a(stack1, stack2)));
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[0]);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return func_94041_b(index, itemStackIn);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index == 1;
    }

    @Override
    public int func_70302_i_() {
        return millItemStacks.size();
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack itemstack : millItemStacks) {
            if (!itemstack.func_190926_b()) {
                return false;
            }
        }

        return true;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return millItemStacks.get(index);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(millItemStacks, index, count);
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(millItemStacks, index);
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = millItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        millItemStacks.set(index, stack);

        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }

        if (index == 1 && millItemStacks.get(1).func_190926_b()) {
            BlockGrindstone.setState(false, field_145850_b, field_174879_c);
            func_70296_d();
        }

        if (index == 0 && !flag) {
            totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime(stack);
            currentItemMillTime = 0;
            func_70296_d();
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double) this.field_174879_c.func_177958_n() + 0.5D, (double) this.field_174879_c.func_177956_o() + 0.5D, (double) this.field_174879_c.func_177952_p() + 0.5D) <= 64.0D;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {

    }

    @Override
    public void func_174886_c(EntityPlayer player) {

    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && GrindstoneRecipes.instance().hasRecipe(stack);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0:
                return this.totalItemMillTime;
            case 1:
                return this.currentItemMillTime;
            default:
                return 0;
        }
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0:
                this.totalItemMillTime = value;
                break;
            case 1:
                this.currentItemMillTime = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public void func_174888_l() {
        millItemStacks.clear();
    }

    @Override
    public String func_70005_c_() {
        return "container.mill";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    private IItemHandler handlerTop = new SidedInvWrapper(this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper(this, EnumFacing.DOWN);

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getCapability(net.minecraftforge.common.capabilities.Capability<T> capability, @javax.annotation.Nullable net.minecraft.util.EnumFacing facing)
    {
        if (facing != null && capability == net.minecraftforge.items.CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
            if (facing == EnumFacing.DOWN)
                return (T) handlerBottom;
            else if (facing == EnumFacing.UP)
                return (T) handlerTop;
        return super.getCapability(capability, facing);
    }
}
