/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityGrindstone
extends TileEntityHPBase {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private int currentItemMillTime;
    private int totalItemMillTime;

    public TileEntityGrindstone() {
        super(2);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("millTime", this.currentItemMillTime);
        compound.setInteger("totalMillTime", this.totalItemMillTime);
        return super.writeToNBT(compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (this.getStackInSlot(0).getCount() > 0) {
            this.currentItemMillTime = compound.getInteger("millTime");
            this.totalItemMillTime = compound.getInteger("totalMillTime");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
        }
    }

    @Override
    public void markDirty() {
        if (this.getStackInSlot(1).isEmpty()) {
            BlockGrindstone.setState(false, this.world, this.pos);
        }
        super.markDirty();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.getPos().add(x, 0, z));
                    this.searchPos.add(this.getPos().add(x, -1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.getWorld().isAirBlock(pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        ++this.currentItemMillTime;
        if (this.currentItemMillTime >= this.totalItemMillTime) {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(this.getStackInSlot(0));
            this.millItem();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(this.getStackInSlot(0));
    }

    @Override
    public int getPositionOffset() {
        return -1;
    }

    private void millItem() {
        if (this.canWork()) {
            ItemStack input = this.getStackInSlot(0);
            ItemStack result = this.getRecipeItemStack();
            ItemStack output = this.getStackInSlot(1);
            if (output.isEmpty()) {
                this.setInventorySlotContents(1, result.copy());
            } else if (output.getItem() == result.getItem()) {
                output.grow(result.getCount());
            }
            input.shrink(1);
            BlockGrindstone.setState(true, this.world, this.pos);
        }
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[]{});
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        super.setInventorySlotContents(index, stack);
        if (index == 1 && this.getStackInSlot(1).isEmpty()) {
            BlockGrindstone.setState(false, this.world, this.pos);
            this.markDirty();
        }
        ItemStack itemstack = this.getStackInSlot(index);
        boolean bl = flag = !stack.isEmpty() && stack.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack);
            this.currentItemMillTime = 0;
            this.markDirty();
        }
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack);
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 2;
    }

    public String getName() {
        return "container.mill";
    }
}

