/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.horsepower.tileentity.TileEntityFiller;

public class BlockFiller
extends BlockDirectional {
    public static final IUnlistedProperty<Integer> MISC_DATA = Properties.toUnlisted((IProperty)PropertyInteger.func_177719_a((String)"misc_data", (int)0, (int)32));
    public boolean useTileEntity;

    public BlockFiller(Material materialIn, String name, boolean useTileEntity) {
        super(materialIn);
        this.setRegistryName(name + "filler");
        this.useTileEntity = useTileEntity;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFiller();
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.useTileEntity;
    }

    private IBlockState getFillerState(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    private int getValue(IExtendedBlockState state, int location, int size) {
        return (Integer)state.getValue(MISC_DATA) >> location & (1 << size) - 1;
    }

    private int setValue(int meta, int location, int value) {
        return meta | value << location;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176387_N}, new IUnlistedProperty[]{MISC_DATA});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState baseState, IBlockAccess worldIn, BlockPos pos) {
        if (baseState instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)baseState;
            IBlockState state1 = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)extState.func_177229_b((IProperty)field_176387_N)));
            int meta = this.setValue(state1.func_177230_c().func_149744_f(state1) ? 1 : 0, 0, 1);
            return ((IExtendedBlockState)baseState).withProperty(MISC_DATA, (Object)meta);
        }
        return super.func_176221_a(baseState, worldIn, pos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        IBlockState state = world.func_180495_p(pos);
        if (!((World)world).field_72995_K && pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).equals((Object)neighbor) && world.func_175623_d(neighbor)) {
            ((World)world).func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().func_185496_a(state1, world, pos);
    }

    public boolean func_180639_a(World w, BlockPos p, IBlockState s, EntityPlayer e, EnumHand h, EnumFacing f, float x, float y, float z) {
        p = p.func_177972_a((EnumFacing)s.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = w.func_180495_p(p);
        return state1.func_177230_c().func_180639_a(w, p, state1, e, h, f, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB func_180640_a(IBlockState s, World w, BlockPos p) {
        p = p.func_177972_a((EnumFacing)s.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = w.func_180495_p(p);
        return state1.func_177230_c().func_180640_a(state1, w, p);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = worldIn.func_180495_p(pos);
        state1.func_177230_c().func_185477_a(state1, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    public final RayTraceResult func_180636_a(IBlockState s, World w, BlockPos p, Vec3d start, Vec3d end) {
        BlockPos p2 = p.func_177972_a((EnumFacing)s.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = w.func_180495_p(p2);
        RayTraceResult trace = state1.func_177230_c().func_180636_a(state1, w, p2, start, end);
        return trace != null ? new RayTraceResult(trace.field_72313_a, trace.field_72307_f, trace.field_178784_b, p) : trace;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().shouldCheckWeakPower(state1, world, pos, side);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        pos = pos.func_177972_a((EnumFacing)blockState.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = blockAccess.func_180495_p(pos);
        return state1.func_177230_c().func_176211_b(state1, blockAccess, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            return this.getValue((IExtendedBlockState)state, 0, 1) == 1;
        }
        return super.func_149744_f(state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        pos = pos.func_177972_a((EnumFacing)blockState.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = blockAccess.func_180495_p(pos);
        return state1.func_177230_c().func_180656_a(state1, blockAccess, pos, side);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        pos = pos.func_177972_a((EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = worldIn.func_180495_p(pos);
        state1.func_177230_c().func_176199_a(worldIn, pos, entityIn);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = worldIn.func_180495_p(pos);
        return state1.func_177230_c().func_185473_a(worldIn, pos, state1);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().getPickBlock(state, target, world, pos, player);
    }

    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().getSoundType(state1, world, pos, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a().func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = worldObj.func_180495_p(pos);
        return state1.func_177230_c().addHitEffects(state1, worldObj, target, manager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        pos = pos.func_177972_a((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().addDestroyEffects(world, pos, manager);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        BlockPos pos = blockPosition.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        IBlockState state1 = worldObj.func_180495_p(pos);
        return state1.func_177230_c().addLandingEffects(state1, worldObj, pos, iblockstate, entity, numberOfParticles);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }
}

