/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.ChopperRecipe;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;

public class HPRecipes {
    private static HPRecipes INSTANCE = new HPRecipes();
    private final ArrayList<GrindstoneRecipe> grindstoneRecipes = Lists.newArrayList();
    private final ArrayList<ChopperRecipe> chopperRecipes = Lists.newArrayList();

    public static HPRecipes instance() {
        return INSTANCE;
    }

    private HPRecipes() {
    }

    public void reloadRecipes() {
        Object stack;
        int time;
        ArrayList stacks;
        String[] comp;
        int i;
        HorsePowerMod.jeiPlugin.removeRecipe();
        this.grindstoneRecipes.clear();
        this.chopperRecipes.clear();
        for (i = 0; i < Configs.grindstoneRecipes.length; ++i) {
            comp = Configs.grindstoneRecipes[i].split("-");
            stacks = Lists.newArrayList();
            time = -1;
            for (String item : comp) {
                if (item.contains(":")) {
                    stack = this.parseItemStack(item);
                    if ((!(stack instanceof ItemStack) || ((ItemStack)stack).func_190926_b()) && (stack instanceof ItemStack || stack == null)) continue;
                    stacks.add(stack);
                    continue;
                }
                try {
                    time = Integer.parseInt(item);
                }
                catch (NumberFormatException e) {
                    System.out.println("[HorsePower] Parse error with grindstone time '" + item + "' in config for input " + stacks.get(0) + " and output " + stacks.get(1) + ".");
                    time = -1;
                }
            }
            if (stacks.size() != 2 || time <= -1) continue;
            if (stacks.get(0) instanceof List) {
                for (Object stack2 : (List)stacks.get(0)) {
                    this.addGrindstoneRecipe((ItemStack)stack2, (ItemStack)stacks.get(1), time);
                }
                continue;
            }
            this.addGrindstoneRecipe((ItemStack)stacks.get(0), (ItemStack)stacks.get(1), time);
        }
        for (i = 0; i < Configs.choppingRecipes.length; ++i) {
            comp = Configs.choppingRecipes[i].split("-");
            stacks = Lists.newArrayList();
            time = -1;
            for (String item : comp) {
                if (item.contains(":")) {
                    stack = this.parseItemStack(item);
                    if ((!(stack instanceof ItemStack) || ((ItemStack)stack).func_190926_b()) && (stack instanceof ItemStack || stack == null)) continue;
                    stacks.add(stack);
                    continue;
                }
                try {
                    time = Integer.parseInt(item);
                }
                catch (NumberFormatException e) {
                    System.out.println("[HorsePower] Parse error with chopping time '" + item + "' in config for input " + stacks.get(0) + " and output " + stacks.get(1) + ".");
                    time = -1;
                }
            }
            if (stacks.size() != 2 || time <= -1) continue;
            if (stacks.get(0) instanceof List) {
                for (Object stack3 : (List)stacks.get(0)) {
                    this.addChopperRecipe((ItemStack)stack3, (ItemStack)stacks.get(1), time);
                }
                continue;
            }
            this.addChopperRecipe((ItemStack)stacks.get(0), (ItemStack)stacks.get(1), time);
        }
        HorsePowerMod.jeiPlugin.addRecipes();
        HorsePowerMod.tweakerPlugin.applyTweaker();
    }

    private Object parseItemStack(String item) {
        int meta;
        int amount;
        String[] data = item.split("@");
        int n = amount = data.length == 1 ? 1 : Integer.parseInt(data[1]);
        if (data.length == 2) {
            item = item.substring(0, item.indexOf("@"));
        }
        int n2 = (data = item.split(":")).length == 2 ? 0 : (meta = "*".equals(data[2]) ? Short.MAX_VALUE : Integer.parseInt(data[2]));
        if (item.startsWith("ore:")) {
            NonNullList items = OreDictionary.getOres((String)item.substring(4));
            return items;
        }
        Item item1 = Item.func_111206_d((String)(data[0] + ":" + data[1]));
        if (item1 == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(item1, amount, meta);
        return stack;
    }

    public void addGrindstoneRecipe(Block input, ItemStack output, int time) {
        this.addGrindstoneRecipe(Item.func_150898_a((Block)input), output, time);
    }

    public void addGrindstoneRecipe(Item input, ItemStack output, int time) {
        this.addGrindstoneRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time);
    }

    public void addGrindstoneRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getGrindstoneResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.grindstoneRecipes.add(new GrindstoneRecipe(input, output, time));
    }

    public void addGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.getGrindstoneResult(recipe.getInput()) != ItemStack.field_190927_a) {
            return;
        }
        this.grindstoneRecipes.add(recipe);
    }

    public void addChopperRecipe(Block input, ItemStack output, int time) {
        this.addChopperRecipe(Item.func_150898_a((Block)input), output, time);
    }

    public void addChopperRecipe(Item input, ItemStack output, int time) {
        this.addChopperRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time);
    }

    public void addChopperRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getChopperResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.chopperRecipes.add(new ChopperRecipe(input, output, time));
    }

    public void addChopperRecipe(ChopperRecipe recipe) {
        if (this.getChopperResult(recipe.getInput()) != ItemStack.field_190927_a) {
            return;
        }
        this.chopperRecipes.add(recipe);
    }

    public void removeGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.hasGrindstoneRecipe(recipe.getInput())) {
            this.grindstoneRecipes.remove(recipe);
        }
    }

    public void removeGrindstoneRecipe(ItemStack input) {
        if (this.hasGrindstoneRecipe(input)) {
            for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)input, (boolean)false)) continue;
                this.grindstoneRecipes.remove(recipe);
            }
        }
    }

    public void removeChopperRecipe(ItemStack input) {
        if (this.hasChopperRecipe(input)) {
            for (ChopperRecipe recipe : this.chopperRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)input, (boolean)false)) continue;
                this.chopperRecipes.remove(recipe);
            }
        }
    }

    public ItemStack getGrindstoneResult(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getChopperResult(ItemStack stack) {
        for (ChopperRecipe recipe : this.chopperRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasGrindstoneRecipe(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChopperRecipe(ItemStack stack) {
        for (ChopperRecipe recipe : this.chopperRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GrindstoneRecipe> getGrindstoneRecipes() {
        return this.grindstoneRecipes;
    }

    public ArrayList<ChopperRecipe> getChopperRecipes() {
        return this.chopperRecipes;
    }

    public int getGrindstoneTime(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getTime();
        }
        return 16;
    }

    public int getChopperTime(ItemStack stack) {
        for (ChopperRecipe recipe : this.chopperRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getTime();
        }
        return 16;
    }
}

