/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.gory_moon.horsepower.blocks.BlockFiller;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.blocks.BlockHandGrindstone;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.util.Localization;

public class Provider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        Provider provider = new Provider();
        registrar.registerStackProvider((IWailaDataProvider)provider, BlockFiller.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockGrindstone.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockHandGrindstone.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockGrindstone.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockHandGrindstone.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock().equals((Object)ModBlocks.BLOCK_CHOPPER_FILLER)) {
            return new ItemStack((Block)ModBlocks.BLOCK_CHOPPER, 1);
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound nbt = accessor.getNBTData();
        if (nbt.hasKey("horsepower:grindstone", 10)) {
            nbt = nbt.getCompoundTag("horsepower:grindstone");
            double total = nbt.getInteger("totalMillTime");
            double current = nbt.getInteger("millTime");
            double progress = (double)Math.round(current / total * 100.0 * 100.0) / 100.0;
            currenttip.add(Localization.WAILA.GRINDSTONE_PROGRESS.translate(String.valueOf(progress) + "%"));
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        NBTTagCompound tile = new NBTTagCompound();
        te.writeToNBT(tile);
        tag.setTag("horsepower:grindstone", (NBTBase)tile);
        return tag;
    }
}

