/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileEntityHPBase
extends TileEntity
implements ISidedInventory {
    protected NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private EnumFacing forward = null;
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);

    public TileEntityHPBase(int inventorySize) {
        NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
    }

    public abstract ItemStack getRecipeItemStack();

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.itemStacks);
        if (this.canBeRotated()) {
            this.forward = EnumFacing.func_176739_a((String)compound.func_74779_i("forward"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.itemStacks);
        if (this.canBeRotated()) {
            compound.func_74778_a("forward", this.getForward().func_176610_l());
        }
        return super.func_189515_b(compound);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.notifyUpdate();
    }

    public boolean canWork() {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = this.getRecipeItemStack();
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack output = this.func_70301_a(1);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(itemstack)) {
            return false;
        }
        int result = output.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= output.func_77976_d();
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void notifyUpdate() {
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public boolean canBeRotated() {
        return false;
    }

    public EnumFacing getForward() {
        if (this.forward == null) {
            return EnumFacing.NORTH;
        }
        return this.forward;
    }

    public void setForward(EnumFacing forward) {
        this.forward = forward;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -999, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
        this.func_70296_d();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index == 1;
    }

    public int func_70302_i_() {
        return this.itemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.itemStacks, (int)index, (int)count);
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.itemStacks, (int)index);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (index == 0 && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStacks.clear();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

