/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.client.renderer.TileEntityHPBaseRenderer;
import se.gory_moon.horsepower.client.renderer.modelvariants.GrindStoneModels;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;

public class TileEntityGrindstoneRender
extends TileEntityHPBaseRenderer<TileEntityGrindstone> {
    public void renderTileEntityAt(TileEntityGrindstone te, double x, double y, double z, float partialTicks, int destroyStage) {
        IBlockState blockState = te.getWorld().getBlockState(te.getPos());
        ItemStack outputStack = te.getStackInSlot(1);
        ItemStack secondaryStack = te.getStackInSlot(2);
        if (outputStack.getCount() < secondaryStack.getCount()) {
            outputStack = secondaryStack;
        }
        if (((Boolean)blockState.getValue((IProperty)BlockGrindstone.FILLED)).booleanValue()) {
            Tessellator tessellator = Tessellator.getInstance();
            VertexBuffer buffer = tessellator.getBuffer();
            BlockRendererDispatcher dispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
            IBlockState filledState = blockState.withProperty(BlockGrindstone.PART, (Comparable)((Object)GrindStoneModels.FILLED));
            IBakedModel filledModel = dispatcher.getBlockModelShapes().getModelForState(filledState);
            this.setRenderSettings();
            buffer.begin(7, DefaultVertexFormats.BLOCK);
            buffer.setTranslation((double)(-te.getPos().getX()), (double)(-te.getPos().getY()), (double)(-te.getPos().getZ()));
            dispatcher.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), filledModel, filledState, te.getPos(), buffer, false);
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)x, (double)y, (double)z);
            GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
            float maxStackSize = outputStack.getMaxStackSize() > 0 ? (float)outputStack.getMaxStackSize() : 1.0f;
            float fillState = 0.23f * ((float)outputStack.getCount() / maxStackSize);
            GlStateManager.translate((double)0.0, (double)(-0.187 + (double)fillState), (double)0.0);
            GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
            tessellator.draw();
            GlStateManager.popMatrix();
            buffer.setTranslation(0.0, 0.0, 0.0);
            RenderHelper.enableStandardItemLighting();
        } else if (outputStack.isEmpty()) {
            te.renderStack = ItemStack.EMPTY;
            te.grindColor = null;
        }
        if (te.hasWorker()) {
            this.renderLeash(te.getWorker(), x, y, z, 0.0, 0.0, 0.0, partialTicks, te.getPos());
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        this.renderItem(te, te.getStackInSlot(0), 0.5f, 1.0f, 0.5f, 1.0f);
        if (!te.getStackInSlot(0).isEmpty() && this.getWorld().isAirBlock(te.getPos().up())) {
            this.drawString(te, String.valueOf(te.getStackInSlot(0).getCount()), 0.0, 0.35, 0.0);
        }
        GlStateManager.popMatrix();
        super.renderTileEntityAt((TileEntity)te, x, y, z, partialTicks, destroyStage);
    }
}

