package se.gory_moon.horsepower.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.Utils;

import java.util.ArrayList;

public abstract class BlockHPBase extends Block {

    protected static boolean keepInventory = false;
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0, 0, 0, 0, 0, 0);

    public BlockHPBase(Material materialIn) {
        super(materialIn);
    }

    public abstract void emptiedOutput(World world, BlockPos pos);

    public int getSlot(IBlockState state, float hitX, float hitY, float hitZ) {
        return -1;
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);

        if (!player.field_71075_bZ.field_75098_d && !worldIn.field_72995_K) {
            TileEntityHPBase te = getTileEntity(worldIn, pos);

            if (te != null) {
                InventoryHelper.func_180175_a(worldIn, pos, te);
                if (te instanceof TileEntityHPHorseBase && ((TileEntityHPHorseBase) te).hasWorker())
                    InventoryHelper.func_180173_a(worldIn, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), new ItemStack(Items.field_151058_ca));
            }
        }
    }

    protected TileEntityHPBase getTileEntity(IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityHPBase ? (TileEntityHPBase)tileentity : null;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!keepInventory && !worldIn.field_72995_K) {
            TileEntity tileentity = worldIn.func_175625_s(pos);

            if (tileentity instanceof TileEntityHPBase) {
                worldIn.func_175666_e(pos, this);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntityHPBase te = (TileEntityHPBase) worldIn.func_175625_s(pos);
        TileEntityHPHorseBase teH = null;
        if (te instanceof TileEntityHPHorseBase)
            teH = (TileEntityHPHorseBase) te;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();

        EntityCreature creature = null;
        ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
        search: for (Class<? extends Entity> clazz: clazzes) {
            for (Object entity : worldIn.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0D, (double)y - 7.0D, (double)z - 7.0D, (double)x + 7.0D, (double)y + 7.0D, (double)z + 7.0D))){
                if (entity instanceof EntityCreature) {
                    EntityCreature tmp = (EntityCreature) entity;
                    if ((tmp.func_110167_bD() && tmp.func_110166_bE() == playerIn)) {
                        creature = tmp;
                        break search;
                    }
                }
            }
        }
        if (teH != null && stack.func_77973_b() instanceof ItemLead && creature != null || creature != null) {
            if (!teH.hasWorker()) {
                creature.func_110160_i(true, false);
                teH.setWorker(creature);
                return true;
            } else {
                return false;
            }
        } else if (!stack.func_190926_b() && te.func_94041_b(0, stack)) {
            ItemStack itemStack = te.func_70301_a(0);
            boolean flag = false;

            if (itemStack.func_190926_b()) {
                te.func_70299_a(0, stack.func_77946_l());
                stack.func_190920_e(stack.func_190916_E() - te.func_70297_j_());
                flag = true;
            } else if (TileEntityHPBase.canCombine(itemStack, stack)) {
                int i = stack.func_77976_d() - itemStack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemStack.func_190917_f(j);
                flag = j > 0;
            }

            if (flag)
                return true;
        }

        int slot = getSlot(state.func_177230_c().getExtendedState(state, worldIn, pos), hitX, hitY, hitZ);
        ItemStack result = ItemStack.field_190927_a;
        if (slot > -1) {
            result = te.func_70304_b(slot);
        } else if (slot > -2){
            result = te.func_70304_b(1);
            if (result.func_190926_b()) {
                result = te.func_70304_b(2);
                if (result.func_190926_b() && stack.func_190926_b() && hand != EnumHand.OFF_HAND) {
                    result = te.func_70304_b(0);
                    if (!result.func_190926_b())
                        emptiedOutput(worldIn, pos);
                }
            }
        }

        if (result.func_190926_b()) {
            if (!stack.func_190926_b())
                return false;
            if (teH != null)
                teH.setWorkerToPlayer(playerIn);
        }

        if (stack.func_190926_b()) {
            playerIn.func_184611_a(hand, result);
        } else if (playerIn.func_191521_c(result)) {
            playerIn.func_71019_a(result, false);
        }

        te.func_70296_d();
        return true;
    }
}
