/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower.Grindstone")
public class GrindstoneRecipeTweaker {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output, int time, @Optional IItemStack secondary, @Optional int secondaryChance) {
        List items = input.getItems();
        if (items == null) {
            HorsePowerMod.logger.error("Cannot turn " + input.toString() + " into a grinding recipe");
        }
        ItemStack[] items2 = MineTweakerMC.getItemStacks((List)items);
        ItemStack output2 = MineTweakerMC.getItemStack((IItemStack)output);
        ItemStack secondary2 = MineTweakerMC.getItemStack((IItemStack)secondary);
        AddGrindstoneRecipe recipe = new AddGrindstoneRecipe(input, items2, output2, secondary2, secondaryChance, time);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        ArrayList toRemove = Lists.newArrayList();
        ArrayList removeIndex = Lists.newArrayList();
        for (int i = 0; i < HPRecipes.instance().getGrindstoneRecipes().size(); ++i) {
            GrindstoneRecipe recipe = HPRecipes.instance().getGrindstoneRecipes().get(i);
            if (!OreDictionary.itemMatches((ItemStack)MineTweakerMC.getItemStack((IIngredient)output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        RemoveGrindstoneRecipe recipe = new RemoveGrindstoneRecipe(toRemove, removeIndex);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    private static class RemoveGrindstoneRecipe
    implements IUndoableAction {
        private final List<Integer> removingIndices;
        private final List<GrindstoneRecipe> recipes;

        private RemoveGrindstoneRecipe(List<GrindstoneRecipe> recipes, List<Integer> removingIndices) {
            this.recipes = recipes;
            this.removingIndices = removingIndices;
        }

        public void apply() {
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                HPRecipes.instance().getGrindstoneRecipes().remove(this.removingIndices.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipes.get(i), "horsepower.grinding");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (int i = 0; i < this.removingIndices.size(); ++i) {
                int index = Math.min(HPRecipes.instance().getGrindstoneRecipes().size(), this.removingIndices.get(i));
                HPRecipes.instance().getGrindstoneRecipes().add(index, this.recipes.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipes.get(i), "horsepower.grinding");
            }
            TweakerPluginImpl.actions.remove(this);
        }

        public String describe() {
            return "Removing " + this.recipes.size() + " grindstone recipes";
        }

        public String describeUndo() {
            return "Restoring " + this.recipes.size() + " grindstone recipes";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddGrindstoneRecipe
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final ItemStack secondary;
        private final int secondaryChance;
        private final int time;

        public AddGrindstoneRecipe(IIngredient ingredient, ItemStack[] inputs, ItemStack output2, ItemStack secondary, int secondaryChance, int time) {
            this.ingredient = ingredient;
            this.input = inputs;
            this.output = output2;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.time = time;
        }

        public void apply() {
            for (ItemStack stack : this.input) {
                GrindstoneRecipe recipe = new GrindstoneRecipe(stack, this.output, this.secondary, this.secondary.isEmpty() ? 0 : this.secondaryChance, this.time);
                HPRecipes.instance().addGrindstoneRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe, "horsepower.grinding");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack stack : this.input) {
                GrindstoneRecipe recipe = HPRecipes.instance().getGrindstoneRecipe(stack);
                HPRecipes.instance().removeGrindstoneRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe, "horsepower.grinding");
            }
            TweakerPluginImpl.actions.remove(this);
        }

        public String describe() {
            return "Adding grindstone recipe for " + this.ingredient;
        }

        public String describeUndo() {
            return "Removing grindstone recipe for " + this.ingredient;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

