/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.tileentity.IHPInventory;

public abstract class TileEntityHPBase
extends TileEntity {
    protected NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    protected IHPInventory inventory;
    private EnumFacing forward = null;
    private IItemHandler handlerTop = null;
    private IItemHandler handlerBottom = null;

    public TileEntityHPBase(int inventorySize) {
        this.itemStacks = NonNullList.withSize((int)inventorySize, (Object)ItemStack.EMPTY);
        this.inventory = new IHPInventory(){

            public int getSizeInventory() {
                return TileEntityHPBase.this.itemStacks.size();
            }

            public boolean isEmpty() {
                for (ItemStack itemstack : TileEntityHPBase.this.itemStacks) {
                    if (itemstack.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            public ItemStack getStackInSlot(int index) {
                return (ItemStack)TileEntityHPBase.this.itemStacks.get(index);
            }

            public ItemStack decrStackSize(int index, int count) {
                ItemStack stack = ItemStackHelper.getAndSplit(TileEntityHPBase.this.itemStacks, (int)index, (int)count);
                if (!stack.isEmpty()) {
                    this.markDirty();
                }
                return stack;
            }

            public ItemStack removeStackFromSlot(int index) {
                ItemStack stack = ItemStackHelper.getAndRemove(TileEntityHPBase.this.itemStacks, (int)index);
                return stack;
            }

            public void setInventorySlotContents(int index, ItemStack stack) {
                TileEntityHPBase.this.setInventorySlotContents(index, stack);
            }

            @Override
            public void setSlotContent(int index, ItemStack stack) {
                TileEntityHPBase.this.itemStacks.set(index, (Object)stack);
                if (index == 0 && stack.getCount() > this.getInventoryStackLimit()) {
                    stack.setCount(this.getInventoryStackLimit());
                }
            }

            public int getInventoryStackLimit() {
                return TileEntityHPBase.this.getInventoryStackLimit();
            }

            public void markDirty() {
                TileEntityHPBase.this.markDirty();
            }

            public boolean isUsableByPlayer(EntityPlayer player) {
                return TileEntityHPBase.this.getWorld().getTileEntity(TileEntityHPBase.this.getPos()) == TileEntityHPBase.this && player.getDistanceSq((double)TileEntityHPBase.this.getPos().getX() + 0.5, (double)TileEntityHPBase.this.getPos().getY() + 0.5, (double)TileEntityHPBase.this.getPos().getZ() + 0.5) <= 64.0;
            }

            public void openInventory(EntityPlayer player) {
            }

            public void closeInventory(EntityPlayer player) {
            }

            public boolean isItemValidForSlot(int index, ItemStack stack) {
                return TileEntityHPBase.this.isItemValidForSlot(index, stack);
            }

            public int getField(int id) {
                return TileEntityHPBase.this.getField(id);
            }

            public void setField(int id, int value) {
                TileEntityHPBase.this.setField(id, value);
            }

            public int getFieldCount() {
                return TileEntityHPBase.this.getFieldCount();
            }

            public void clear() {
                TileEntityHPBase.this.itemStacks.clear();
            }

            public String getName() {
                return TileEntityHPBase.this.getName();
            }

            public boolean hasCustomName() {
                return false;
            }

            public ITextComponent getDisplayName() {
                return TileEntityHPBase.this.getDisplayName();
            }
        };
        this.handlerTop = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 0, 1);
        this.handlerBottom = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 1, this.getOutputSlot() + 1);
    }

    public abstract HPRecipeBase getRecipe();

    public abstract ItemStack getRecipeItemStack();

    public abstract int getInventoryStackLimit();

    public abstract boolean isItemValidForSlot(int var1, ItemStack var2);

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public abstract String getName();

    public abstract int getOutputSlot();

    public ItemStack getStackInSlot(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack removeStackFromSlot(int index) {
        return this.inventory.removeStackFromSlot(index);
    }

    public IHPInventory getInventory() {
        return this.inventory;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inventory.setSlotContent(index, stack);
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.itemStacks = NonNullList.withSize((int)this.inventory.getSizeInventory(), (Object)ItemStack.EMPTY);
        ItemStackHelper.loadAllItems((NBTTagCompound)compound, this.itemStacks);
        if (this.canBeRotated()) {
            this.forward = EnumFacing.byName((String)compound.getString("forward"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        ItemStackHelper.saveAllItems((NBTTagCompound)compound, this.itemStacks);
        if (this.canBeRotated()) {
            compound.setString("forward", this.getForward().getName());
        }
        return compound;
    }

    public void markDirty() {
        if (!this.getWorld().isRemote) {
            IBlockState state = this.getWorld().getBlockState(this.getPos());
            this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 8);
            super.markDirty();
        }
    }

    public boolean canWork() {
        if (this.inventory.getStackInSlot(0).isEmpty()) {
            return false;
        }
        HPRecipeBase recipeBase = this.getRecipe();
        if (recipeBase == null) {
            return false;
        }
        ItemStack itemstack = recipeBase.getOutput();
        ItemStack secondary = recipeBase.getSecondary();
        if (itemstack.isEmpty()) {
            return false;
        }
        ItemStack output = this.inventory.getStackInSlot(1);
        ItemStack outputSecondary = this.inventory.getStackInSlot(2);
        if (!secondary.isEmpty() && !outputSecondary.isEmpty()) {
            if (!outputSecondary.isItemEqual(secondary)) {
                return false;
            }
            if (outputSecondary.getCount() + secondary.getCount() > secondary.getMaxStackSize()) {
                return false;
            }
        }
        return output.isEmpty() || output.isItemEqual(itemstack) && output.getCount() + itemstack.getCount() <= output.getMaxStackSize();
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && stack1.getMetadata() == stack2.getMetadata() && stack1.getCount() <= stack1.getMaxStackSize() && ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public boolean canBeRotated() {
        return false;
    }

    public EnumFacing getForward() {
        if (this.forward == null) {
            return EnumFacing.NORTH;
        }
        return this.forward;
    }

    public void setForward(EnumFacing forward) {
        this.forward = forward;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), -999, this.getUpdateTag());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.getNbtCompound());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromNBT(tag);
        this.markDirty();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == EnumFacing.DOWN || facing == EnumFacing.UP) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

