/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.Localization;

public class TileEntityChopper
extends TileEntityHPHorseBase {
    private int currentWindup;
    private int currentItemChopTime;
    private int totalItemChopTime;
    private float visualWindup = 0.0f;
    private float oldVisualWindup = -1.0f;
    private IItemHandler handlerSide = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 0, 1);

    public TileEntityChopper() {
        super(2);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("currentWindup", this.currentWindup);
        compound.setInteger("chopTime", this.currentItemChopTime);
        compound.setInteger("totalChopTime", this.totalItemChopTime);
        return super.writeToNBT(compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.currentWindup = compound.getInteger("currentWindup");
        if (this.inventory.getStackInSlot(0).getCount() > 0) {
            this.currentItemChopTime = compound.getInteger("chopTime");
            this.totalItemChopTime = compound.getInteger("totalChopTime");
        } else {
            this.currentItemChopTime = 0;
            this.totalItemChopTime = 1;
        }
    }

    @Override
    public void markDirty() {
        super.markDirty();
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasChopperRecipe(stack) && this.inventory.getStackInSlot(1).isEmpty() && this.inventory.getStackInSlot(0).isEmpty();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.getPos().add(x, 0, z));
                    this.searchPos.add(this.getPos().add(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.getWorld().getBlockState(pos).getBlock().isReplaceable((IBlockAccess)this.world, pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update() {
        super.update();
        float windup = Configs.pointsForWindup > 0 ? (float)Configs.pointsForWindup : 1.0f;
        this.visualWindup = -0.74f + 0.74f * ((float)this.currentWindup / (windup - 1.0f));
    }

    @Override
    public boolean targetReached() {
        ++this.currentWindup;
        if (this.currentWindup >= Configs.pointsForWindup) {
            this.currentWindup = 0;
            ++this.currentItemChopTime;
            if (this.currentItemChopTime >= this.totalItemChopTime) {
                this.currentItemChopTime = 0;
                this.totalItemChopTime = HPRecipes.instance().getChoppingTime(this.inventory.getStackInSlot(0));
                this.chopItem();
                return true;
            }
        }
        this.markDirty();
        return false;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.inventory.getStackInSlot(index);
        super.setInventorySlotContents(index, stack);
        if (index == 1 && this.inventory.getStackInSlot(1).isEmpty()) {
            this.markDirty();
        }
        boolean bl = flag = !stack.isEmpty() && stack.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemChopTime = HPRecipes.instance().getChoppingTime(stack);
            this.currentItemChopTime = 0;
            this.currentWindup = 0;
            this.markDirty();
        }
    }

    private void chopItem() {
        if (this.canWork()) {
            ItemStack input = this.inventory.getStackInSlot(0);
            ItemStack result = this.getRecipeItemStack();
            ItemStack output = this.inventory.getStackInSlot(1);
            if (output.isEmpty()) {
                this.setInventorySlotContents(1, result.copy());
            } else if (output.getItem() == result.getItem()) {
                output.grow(result.getCount());
            }
            input.shrink(1);
            this.markDirty();
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getChopperResult(this.inventory.getStackInSlot(0));
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getChoppingBlockRecipe(this.inventory.getStackInSlot(0));
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemChopTime;
            }
            case 1: {
                return this.currentItemChopTime;
            }
            case 2: {
                return this.currentWindup;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemChopTime = value;
                break;
            }
            case 1: {
                this.currentItemChopTime = value;
            }
            case 2: {
                this.currentWindup = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public String getName() {
        return "container.chopper";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    public float getVisualWindup() {
        return this.visualWindup;
    }

    public float getOldVisualWindup() {
        return this.oldVisualWindup;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        if (this.valid) {
            return super.getDisplayName();
        }
        return new TextComponentTranslation(Localization.INFO.CHOPPING_INVALID.key(), new Object[0]).setStyle(new Style().setColor(TextFormatting.RED));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T cap = super.getCapability(capability, facing);
        return (T)(cap != null ? cap : (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.handlerSide : null));
    }
}

