package se.gory_moon.horsepower.recipes;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;

import javax.annotation.Nonnull;
import java.util.List;

import static se.gory_moon.horsepower.blocks.BlockChopper.createItemStack;


public class ChoppingRecipe extends ShapedOreRecipe {

    static {
        RecipeSorter.register("horsepower:chopping", ChoppingRecipe.class, RecipeSorter.Category.SHAPED, "before:minecraft:shaped");
    }

    public final List<ItemStack> outputBlocks;

    public ChoppingRecipe(List<ItemStack> variantItems, BlockHPChoppingBase result, Object... recipe) {
        super(result, recipe);
        this.outputBlocks = variantItems;
    }

    @Nonnull
    @Override
    public ItemStack func_77572_b(@Nonnull InventoryCrafting craftMatrix) {
        for(int i = 0; i < craftMatrix.func_70302_i_(); i++) {
            for (ItemStack ore: outputBlocks) {
                ItemStack stack = craftMatrix.func_70301_a(i);
                if (OreDictionary.itemMatches(ore, stack, false) && Block.func_149634_a(stack.func_77973_b()) != Blocks.field_150350_a) {
                    BlockHPChoppingBase block = (BlockHPChoppingBase) Block.func_149634_a(getSimpleRecipeOutput().func_77973_b());
                    return createItemStack(block, Block.func_149634_a(stack.func_77973_b()), stack.func_77952_i());
                }
            }
        }
        return super.func_77572_b(craftMatrix);
    }

    @Nonnull
    @Override
    public ItemStack func_77571_b() {
        if (!outputBlocks.isEmpty() && !output.func_190926_b()) {
            ItemStack stack = outputBlocks.get(0);
            BlockHPChoppingBase block = (BlockHPChoppingBase) Block.func_149634_a(output.func_77973_b());
            int meta = stack.func_77960_j();
            if (meta == OreDictionary.WILDCARD_VALUE)
                meta = 0;
            return createItemStack(block, Block.func_149634_a(stack.func_77973_b()), meta);

        }
        return super.func_77571_b();
    }

    public ItemStack getSimpleRecipeOutput() {
        return output;
    }


}
