package se.gory_moon.horsepower.waila;

import mcp.mobius.waila.api.*;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.*;
import se.gory_moon.horsepower.lib.Reference;
import se.gory_moon.horsepower.tileentity.*;
import se.gory_moon.horsepower.util.Localization;

import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;

public class Provider implements IWailaDataProvider {

    public static void callbackRegister(IWailaRegistrar registrar) {
        Provider provider = new Provider();

        registrar.registerStackProvider(provider, BlockFiller.class);
        registrar.registerBodyProvider(provider, BlockGrindstone.class);
        registrar.registerBodyProvider(provider, BlockHandGrindstone.class);
        registrar.registerBodyProvider(provider, BlockHPChoppingBase.class);
        registrar.registerBodyProvider(provider, BlockPress.class);
        registrar.registerBodyProvider(provider, BlockFiller.class);
        registrar.registerNBTProvider(provider, BlockGrindstone.class);
        registrar.registerNBTProvider(provider, BlockHandGrindstone.class);
        registrar.registerNBTProvider(provider, BlockChopper.class);
        registrar.registerNBTProvider(provider, BlockChoppingBlock.class);
        registrar.registerNBTProvider(provider, BlockPress.class);
        registrar.registerNBTProvider(provider, BlockFiller.class);
        registrar.addConfig(Reference.NAME, "horsepower:showItems", Localization.WAILA.SHOW_ITEMS.translate());
        registrar.registerTooltipRenderer("horsepower.stack", new TTRenderStack());
    }

    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock().equals(ModBlocks.BLOCK_CHOPPER_FILLER))
            return accessor.getBlock().getPickBlock(accessor.getBlockState(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound nbt = accessor.getNBTData();
        if (nbt.func_150297_b("horsepower:grindstone", 10)) {
            nbt = nbt.func_74775_l("horsepower:grindstone");

            double total = (double) nbt.func_74762_e("totalMillTime");
            double current = (double) nbt.func_74762_e("millTime");
            double progress = Math.round(((current / total) * 100D) * 100D) / 100D;
            currenttip.add(Localization.WAILA.GRINDSTONE_PROGRESS.translate(String.valueOf(progress) + "%"));
        } else if (nbt.func_150297_b("horsepower:chopper", 10)) {
            nbt = nbt.func_74775_l("horsepower:chopper");

            double totalWindup = Configs.general.pointsForWindup > 0 ? Configs.general.pointsForWindup : 1;
            double windup = (double) nbt.func_74762_e("currentWindup");
            double current = (double) nbt.func_74762_e("chopTime");
            double total = (double) nbt.func_74762_e("totalChopTime");
            double progressWindup = Math.round(((windup / totalWindup) * 100D) * 100D) / 100D;
            double progressChopping = Math.round(((current / total) * 100D) * 100D) / 100D;

            if (accessor.getTileEntity() instanceof TileEntityChopper || accessor.getTileEntity() instanceof TileEntityFiller)
                currenttip.add(Localization.WAILA.WINDUP_PROGRESS.translate(String.valueOf(progressWindup) + "%"));
            if (total > 1 || accessor.getTileEntity() instanceof TileEntityManualChopper) {
                currenttip.add(Localization.WAILA.CHOPPING_PROGRESS.translate(String.valueOf(progressChopping) + "%"));
            }
        } else if (nbt.func_74764_b("horsepower:press")) {
            nbt = nbt.func_74775_l("horsepower:press");
            double current = (double) nbt.func_74762_e("currentPressStatus");
            double total = Configs.general.pointsForPress > 0 ? Configs.general.pointsForPress: 1;
            double progress = Math.round(((current / total) * 100D) * 100D) / 100D;
            currenttip.add(Localization.WAILA.PRESS_PROGRESS.translate(String.valueOf(progress) + "%"));
        }

        if (config.getConfig("horsepower:showItems") && (accessor.getTileEntity() instanceof TileEntityHPBase || accessor.getTileEntity() instanceof TileEntityFiller) && accessor.getPlayer().func_70093_af()) {
            TileEntity te = accessor.getTileEntity();
            {
                final ItemStack stack = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP).getStackInSlot(0);
                final String name = String.valueOf(stack.func_77973_b().getRegistryName().toString());
                if (!stack.func_190926_b())
                    currenttip.add(SpecialChars.getRenderString("horsepower.stack", "1", name, String.valueOf(stack.func_190916_E()), String.valueOf(stack.func_77952_i()), String.valueOf(Base64.getEncoder().encodeToString(stack.serializeNBT().toString().getBytes(Charset.forName("UTF-8"))))) + SpecialChars.TAB + SpecialChars.WHITE + stack.func_82833_r());
            }
            {
                final ItemStack stack = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP).getStackInSlot(1);
                final String name = String.valueOf(stack.func_77973_b().getRegistryName().toString());
                if (!stack.func_190926_b())
                    currenttip.add(SpecialChars.getRenderString("horsepower.stack", "1", name, String.valueOf(stack.func_190916_E()), String.valueOf(stack.func_77952_i()), String.valueOf(Base64.getEncoder().encodeToString(stack.serializeNBT().toString().getBytes(Charset.forName("UTF-8"))))) + SpecialChars.TAB + SpecialChars.WHITE + stack.func_82833_r());
            }
            {
                final ItemStack stack = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP).getStackInSlot(2);
                final String name = String.valueOf(stack.func_77973_b().getRegistryName().toString());
                if (!stack.func_190926_b())
                    currenttip.add(SpecialChars.getRenderString("horsepower.stack", "1", name, String.valueOf(stack.func_190916_E()), String.valueOf(stack.func_77952_i()), String.valueOf(Base64.getEncoder().encodeToString(stack.serializeNBT().toString().getBytes(Charset.forName("UTF-8"))))) + SpecialChars.TAB + SpecialChars.WHITE + stack.func_82833_r());
            }
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        NBTTagCompound tile = new NBTTagCompound();
        if (te instanceof TileEntityFiller)
            te = ((TileEntityFiller) te).getFilledTileEntity();
        if (te != null)
            te.func_189515_b(tile);
        if (te instanceof TileEntityGrindstone || te instanceof TileEntityHandGrindstone)
            tag.func_74782_a("horsepower:grindstone", tile);
        else if (te instanceof TileEntityChopper || te instanceof TileEntityManualChopper)
            tag.func_74782_a("horsepower:chopper", tile);
        else if (te instanceof TileEntityPress)
            tag.func_74782_a("horsepower:press", tile);
        return tag;
    }
}
