package se.gory_moon.horsepower.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

import javax.annotation.Nullable;

public abstract class TileEntityHPBase extends TileEntity implements ISidedInventory {

    protected NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a(2, ItemStack.field_190927_a);

    private EnumFacing forward = null;

    public TileEntityHPBase(int inventorySize) {
        NonNullList.func_191197_a(inventorySize, ItemStack.field_190927_a);
    }

    public abstract ItemStack getRecipeItemStack();

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        itemStacks = NonNullList.func_191197_a(this.func_70302_i_(), ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b(compound, itemStacks);

        if (canBeRotated()) {
            forward = EnumFacing.func_176739_a(compound.func_74779_i("forward"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a(compound, itemStacks);

        if (canBeRotated()) {
            compound.func_74778_a("forward", getForward().func_176610_l());
        }
        return compound;
    }

    @Override
    public void func_70296_d() {
        if (!func_145831_w().field_72995_K) {
            final IBlockState state = func_145831_w().func_180495_p(func_174877_v());
            func_145831_w().func_184138_a(func_174877_v(), state, state, 8);
            super.func_70296_d();
        }
    }

    public boolean canWork() {
        if (func_70301_a(0).func_190926_b()) {
            return false;
        } else {
            ItemStack itemstack = getRecipeItemStack();

            if (itemstack.func_190926_b()) {
                return false;
            } else {
                ItemStack output = func_70301_a(1);
                if (output.func_190926_b()) return true;
                if (!output.func_77969_a(itemstack)) return false;
                int result = output.func_190916_E() + itemstack.func_190916_E();
                return result <= func_70297_j_() && result <= output.func_77976_d();
            }
        }
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == stack2.func_77960_j() && (stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a(stack1, stack2)));
    }

    public boolean canBeRotated() {
        return false;
    }

    public EnumFacing getForward() {
        if (forward == null)
            return EnumFacing.NORTH;
        return forward;
    }

    public void setForward(EnumFacing forward) {
        this.forward = forward;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(func_174877_v(), -999, func_189517_E_());
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return func_189515_b(new NBTTagCompound());
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        func_145839_a(tag);
        func_70296_d();
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return func_94041_b(index, itemStackIn);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index == 1;
    }

    @Override
    public int func_70302_i_() {
        return itemStacks.size();
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack itemstack : itemStacks) {
            if (!itemstack.func_190926_b()) {
                return false;
            }
        }

        return true;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return itemStacks.get(index);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(itemStacks, index, count);
        if (!stack.func_190926_b())
            func_70296_d();
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(itemStacks, index);
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        itemStacks.set(index, stack);

        if (index == 0 && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double) this.field_174879_c.func_177958_n() + 0.5D, (double) this.field_174879_c.func_177956_o() + 0.5D, (double) this.field_174879_c.func_177952_p() + 0.5D) <= 64.0D;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {}

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
        itemStacks.clear();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    private IItemHandler handlerTop = new SidedInvWrapper(this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper(this, EnumFacing.DOWN);

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getCapability(net.minecraftforge.common.capabilities.Capability<T> capability, @javax.annotation.Nullable net.minecraft.util.EnumFacing facing) {
        if (facing != null && capability == net.minecraftforge.items.CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
            if (facing == EnumFacing.DOWN)
                return (T) handlerBottom;
            else if (facing == EnumFacing.UP)
                return (T) handlerTop;
        return super.getCapability(capability, facing);
    }
}
