package se.gory_moon.horsepower.items;

import com.google.common.collect.Maps;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.lib.Constants;
import se.gory_moon.horsepower.lib.Reference;
import se.gory_moon.horsepower.recipes.ChoppingRecipe;

import java.util.*;

@GameRegistry.ObjectHolder(Reference.MODID)
@Mod.EventBusSubscriber(modid = Reference.MODID)
public class ModItems {

    public static final Item FLOUR = new Item().setRegistryName(Constants.FLOUR_ITEM).func_77655_b(Constants.FLOUR_ITEM).func_77637_a(HorsePowerMod.creativeTab);
    public static final Item DOUGH = new Item().setRegistryName(Constants.DOUGH_ITEM).func_77655_b(Constants.DOUGH_ITEM).func_77637_a(HorsePowerMod.creativeTab);

    private static Set<Map.Entry<ResourceLocation, IRecipe>> recipes;
    private static List<ResourceLocation> recipesToRemove = new LinkedList<>();

    @Mod.EventBusSubscriber(modid = Reference.MODID)
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<>();

        /**
         * Register this mod's {@link Item}s.
         *
         * @param event The event
         */
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {

            final Item[] items = {FLOUR, DOUGH};

            final IForgeRegistry<Item> registry = event.getRegistry();

            for (final Item item : items) {
                if (!Configs.general.enableFlour && item == FLOUR)
                    continue;
                if (!Configs.general.enableDough && item == DOUGH)
                    continue;

                registry.register(item);
                ITEMS.add(item);
            }
        }
    }

    public static void registerRecipes() {
        if (Configs.general.enableDough) {
            GameRegistry.addSmelting(DOUGH, new ItemStack(Items.field_151025_P), 0F);
            OreDictionary.registerOre("foodDough", DOUGH);
        }
        if (Configs.general.enableFlour)
            OreDictionary.registerOre("foodFlour", FLOUR);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> ev) throws NoSuchFieldException, IllegalAccessException {
        recipes = ev.getRegistry().getEntries();
        ResourceLocation loc = new ResourceLocation("horsepower:chopper");
        ev.getRegistry().register(new ChoppingRecipe(loc, OreDictionary.getOres("logWood"), new ItemStack(ModBlocks.BLOCK_CHOPPER), "LSL", "SFS", "SWS", 'S', "stickWood", 'L', Ingredient.func_193369_a(new ItemStack(Items.field_151058_ca)), 'F', Ingredient.func_193369_a(new ItemStack(Items.field_151145_ak)), 'W', "logWood").setRegistryName(loc));
        if (Configs.general.enableHandChoppingBlock) {
            loc = new ResourceLocation("horsepower:manual_chopping");
            ev.getRegistry().register(new ChoppingRecipe(loc, OreDictionary.getOres("logWood"), new ItemStack(ModBlocks.BLOCK_MANUAL_CHOPPER), "W", 'W', "logWood").setRegistryName(loc));
        }

        if (Configs.general.removeVanillaRecipes)
            removeRecipes();
    }

    private static void removeRecipes() {
        Container dummyContainer = new Container() {
            @Override
            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }

            @Override
            public void func_75130_a(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 3, 3);


        removeRecipe(findMatchingRecipe(setRecipe(crafting, "###", '#', Items.field_151015_O)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', Items.field_151120_aE)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_189880_di))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', Items.field_151103_aS)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', Items.field_185164_cV)));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()))));

        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()))));
        removeRecipe(findMatchingRecipe(setRecipe(crafting, "#", '#', new ItemStack(Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()))));

        recipesToRemove.forEach(recipe -> RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe));
    }

    private static InventoryCrafting setRecipe(InventoryCrafting crafting, Object... recipeComponents) {
        crafting.func_174888_l();
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;

        if (recipeComponents[i] instanceof String[]) {
            String[] astring = (String[])recipeComponents[i++];

            for (String s2 : astring) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }

        Map<Character, ItemStack> map;

        for (map = Maps.newHashMap(); i < recipeComponents.length; i += 2) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = ItemStack.field_190927_a;

            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, 32767);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }

            map.put(character, itemstack);
        }


        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);

            if (map.containsKey(Character.valueOf(c0))) {
                crafting.func_70299_a(l, map.get(Character.valueOf(c0)).func_77946_l());
            }
        }

        return crafting;
    }

    private static void removeRecipesWithResult(ItemStack resultItem) {

        for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
            ItemStack recipeResult = recipe.getValue().func_77571_b();
            if (ItemStack.func_77989_b(resultItem, recipeResult)) {
                recipesToRemove.add(recipe.getKey());
            }
        }
    }

    private static void removeRecipe(ResourceLocation recipe) {
        if (recipe != null)
            recipesToRemove.add(recipe);
    }

    public static ResourceLocation findMatchingRecipe(InventoryCrafting craftMatrix) {
        for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
            if (recipe.getValue().func_77569_a(craftMatrix, null)) {
                return recipe.getKey();
            }
        }

        return null;
    }
}
