/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.jei.ShapedChoppingCraftingWrapper;
import se.gory_moon.horsepower.jei.ShapelessChoppingCraftingWrapper;
import se.gory_moon.horsepower.jei.chopping.ChoppingRecipeMaker;
import se.gory_moon.horsepower.jei.chopping.ChoppingRecipeWrapper;
import se.gory_moon.horsepower.jei.chopping.HorsePowerChoppingCategory;
import se.gory_moon.horsepower.jei.grinding.GrindingRecipeMaker;
import se.gory_moon.horsepower.jei.grinding.GrindstoneRecipeWrapper;
import se.gory_moon.horsepower.jei.grinding.HorsePowerGrindingCategory;
import se.gory_moon.horsepower.jei.press.HorsePowerPressCategory;
import se.gory_moon.horsepower.jei.press.PressRecipeMaker;
import se.gory_moon.horsepower.jei.press.PressRecipeWrapper;
import se.gory_moon.horsepower.recipes.ChoppingBlockRecipe;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HandGrindstoneRecipe;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.recipes.ShapedChoppingRecipe;
import se.gory_moon.horsepower.recipes.ShapelessChoppingRecipe;

@JEIPlugin
public class HorsePowerPlugin
implements IModPlugin {
    public static final String HAND_GRINDING = "horsepower.hand_grinding";
    public static final String GRINDING = "horsepower.grinding";
    public static final String MANUAL_CHOPPING = "horsepower.manual_chopping";
    public static final String CHOPPING = "horsepower.chopping";
    public static final String PRESS = "horsepower.press";
    public static IJeiHelpers jeiHelpers;
    public static IGuiHelper guiHelper;
    private static IJeiRuntime jeiRuntime;
    public static IRecipeRegistry recipeRegistry;
    public static ICraftingGridHelper craftingGridHelper;

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.handleRecipes(HandGrindstoneRecipe.class, GrindstoneRecipeWrapper::new, HAND_GRINDING);
            registry.addRecipes(GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, true), HAND_GRINDING);
        }
        if (Configs.general.enableHandChoppingBlock && Configs.recipes.useSeperateChoppingRecipes) {
            registry.handleRecipes(ChoppingBlockRecipe.class, ChoppingRecipeWrapper::new, MANUAL_CHOPPING);
            registry.addRecipes(ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, true), MANUAL_CHOPPING);
        }
        registry.handleRecipes(GrindstoneRecipe.class, GrindstoneRecipeWrapper::new, GRINDING);
        registry.addRecipes(GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, false), GRINDING);
        registry.handleRecipes(ChoppingBlockRecipe.class, ChoppingRecipeWrapper::new, CHOPPING);
        registry.addRecipes(ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, false), CHOPPING);
        registry.handleRecipes(PressRecipe.class, PressRecipeWrapper::new, PRESS);
        registry.addRecipes(PressRecipeMaker.getPressRecipes(jeiHelpers), PRESS);
        registry.handleRecipes(ShapedChoppingRecipe.class, ShapedChoppingCraftingWrapper::new, "minecraft.crafting");
        registry.handleRecipes(ShapelessChoppingRecipe.class, ShapelessChoppingCraftingWrapper::new, "minecraft.crafting");
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_HAND_GRINDSTONE), new String[]{HAND_GRINDING});
        } else {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_HAND_GRINDSTONE), new String[]{GRINDING});
        }
        if (Configs.general.enableHandChoppingBlock) {
            ItemStack itemStackManualChopper = BlockHPChoppingBase.createItemStack(ModBlocks.BLOCK_MANUAL_CHOPPER, 1, new ItemStack(Item.getItemFromBlock((Block)Blocks.LOG)));
            if (Configs.recipes.useSeperateChoppingRecipes) {
                registry.addRecipeCatalyst((Object)itemStackManualChopper, new String[]{MANUAL_CHOPPING});
            } else {
                registry.addRecipeCatalyst((Object)itemStackManualChopper, new String[]{CHOPPING});
            }
        }
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_GRINDSTONE), new String[]{GRINDING});
        ItemStack itemStackChopper = BlockHPChoppingBase.createItemStack(ModBlocks.BLOCK_CHOPPER, 1, new ItemStack(Item.getItemFromBlock((Block)Blocks.LOG)));
        registry.addRecipeCatalyst((Object)itemStackChopper, new String[]{CHOPPING});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_PRESS), new String[]{PRESS});
        registry.addIngredientInfo((Object)new ItemStack((Block)ModBlocks.BLOCK_GRINDSTONE), ItemStack.class, new String[]{"info.horsepower:grindstone.info1", "info.horsepower:grindstone.info2", "info.horsepower:grindstone.info3"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        HorsePowerPlugin.jeiRuntime = jeiRuntime;
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(Item.getItemFromBlock((Block)ModBlocks.BLOCK_CHOPPER), itemStack -> {
            NBTTagCompound nbtTagCompound = itemStack.getTagCompound();
            if (itemStack.getMetadata() == Short.MAX_VALUE || nbtTagCompound == null || nbtTagCompound.hasNoTags()) {
                return null;
            }
            return nbtTagCompound.toString();
        });
        subtypeRegistry.registerSubtypeInterpreter(Item.getItemFromBlock((Block)ModBlocks.BLOCK_MANUAL_CHOPPER), itemStack -> {
            NBTTagCompound nbtTagCompound = itemStack.getTagCompound();
            if (itemStack.getMetadata() == Short.MAX_VALUE || nbtTagCompound == null || nbtTagCompound.hasNoTags()) {
                return null;
            }
            return nbtTagCompound.toString();
        });
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerGrindingCategory(registry.getJeiHelpers().getGuiHelper(), true)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerGrindingCategory(registry.getJeiHelpers().getGuiHelper(), false)});
        if (Configs.general.enableHandChoppingBlock && Configs.recipes.useSeperateChoppingRecipes) {
            registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerChoppingCategory(registry.getJeiHelpers().getGuiHelper(), true)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerChoppingCategory(registry.getJeiHelpers().getGuiHelper(), false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerPressCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

