/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.advancements.Manager;
import se.gory_moon.horsepower.blocks.BlockFiller;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.client.model.modelvariants.ChopperModels;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.color.Colors;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockChopper
extends BlockHPChoppingBase
implements IProbeInfoAccessor {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing", Arrays.asList(EnumFacing.HORIZONTALS));
    public static final PropertyEnum<ChopperModels> PART = PropertyEnum.create((String)"part", ChopperModels.class);
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockChopper() {
        this.setHardness(5.0f);
        this.setResistance(5.0f);
        this.setRegistryName("chopper");
        this.setUnlocalizedName("chopper");
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasCustomBreakingProgress(IBlockState state) {
        return true;
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{PART, FACING}, new IUnlistedProperty[]{SIDE_TEXTURE, TOP_TEXTURE});
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!((World)world).isRemote && pos.up().equals((Object)neighbor) && !(world.getBlockState(neighbor).getBlock() instanceof BlockFiller)) {
            ((World)world).setBlockState(pos, Blocks.AIR.getDefaultState(), 3);
        }
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isRemote) {
            EnumFacing enumfacing = (EnumFacing)state.getValue((IProperty)FACING);
            worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)enumfacing).withProperty(PART, (Comparable)((Object)ChopperModels.BASE)), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()).withProperty(PART, (Comparable)((Object)ChopperModels.BASE));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.getFront((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing).withProperty(PART, (Comparable)((Object)ChopperModels.BASE));
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()), 2);
        Object tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        ((TileEntityHPBase)((Object)tile)).setForward(placer.getHorizontalFacing().getOpposite());
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {
    }

    @Override
    public void onWorkerAttached(EntityPlayer playerIn, EntityCreature creature) {
        if (playerIn instanceof EntityPlayerMP) {
            Manager.USE_CHOPPER.trigger((EntityPlayerMP)playerIn);
        }
    }

    @Override
    @Nonnull
    public Class<?> getTileClass() {
        return TileEntityChopper.class;
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.SIZE.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.LOCATION.translate(new String[0]));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.USE.translate(new String[0]));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityChopper tileEntity = (TileEntityChopper)((Object)this.getTileEntity((IBlockAccess)world, data.getPos()));
        if (tileEntity != null) {
            double totalWindup = Configs.general.pointsForWindup > 0 ? (double)Configs.general.pointsForWindup : 1.0;
            probeInfo.progress((long)((double)tileEntity.getField(2) / totalWindup * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.WINDUP_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            if (tileEntity.getField(0) > 1) {
                probeInfo.progress((long)((double)tileEntity.getField(1) / (double)tileEntity.getField(0) * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.CHOPPING_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            }
        }
    }
}

