package se.gory_moon.horsepower.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.property.PropertyUnlistedString;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.RenderUtils;
import se.gory_moon.horsepower.util.Utils;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

public abstract class BlockHPChoppingBase extends BlockHPBase {

    public static final PropertyUnlistedString SIDE_TEXTURE = new PropertyUnlistedString("side_texture");
    public static final PropertyUnlistedString TOP_TEXTURE = new PropertyUnlistedString("top_texture");

    public BlockHPChoppingBase() {
        super(Material.field_151575_d);
        setHarvestLevel("axe", 0);
        func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState) state;

        TileEntityHPBase tile = getTileEntity(world, pos);
        if (tile != null) {
            return getExtendedState(tile, tile.getExtendedState(extendedState));
        }

        return super.getExtendedState(state, world, pos);
    }

    private void writeDataOntoItemstack(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean inventorySave) {
        // get block data from the block
        TileEntity te = world.func_175625_s(pos);
        if(te != null && (te instanceof TileEntityChopper || te instanceof TileEntityManualChopper)) {
            NBTTagCompound tag = item.func_77942_o() ? item.func_77978_p(): new NBTTagCompound();

            // texture
            NBTTagCompound data = te.getTileData().func_74775_l("textureBlock");

            if (!data.func_82582_d()) {
                tag.func_74782_a("textureBlock", data);
            }

            if (!tag.func_82582_d()) {
                item.func_77982_d(tag);
            }
        }
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        List<ItemStack> drops = new ArrayList<>();
        Item item = this.func_180660_a(state, world.field_73012_v, 0);
        if (item != Items.field_190931_a) {
            drops.add(new ItemStack(item, 1, this.func_180651_a(state)));
        }

        if(drops.size() > 0) {
            ItemStack stack = drops.get(0);
            writeDataOntoItemstack(stack, world, pos, state, false);
            return stack;
        }

        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if(!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {

            List<ItemStack> items = this.getDrops(worldIn, pos, state, fortune);
            chance = net.minecraftforge.event.ForgeEventFactory.fireBlockHarvesting(items, worldIn, pos, state, fortune, chance, false, harvesters.get());

            for(ItemStack item : items) {
                // save the data from the block onto the item
                if(item.func_77973_b() == Item.func_150898_a(this)) {
                    writeDataOntoItemstack(item, worldIn, pos, state, chance >= 1f);
                }
            }

            for(ItemStack item : items) {
                if(worldIn.field_73012_v.nextFloat() <= chance) {
                    func_180635_a(worldIn, pos, item);
                }
            }
        }
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p(): new NBTTagCompound();
        TileEntityHPBase tile = getTileEntity(worldIn, pos);
        if (tile == null)
            return;
        NBTTagCompound baseTag = tag != null ? tag.func_74775_l("textureBlock"): new NBTTagCompound();
        tile.getTileData().func_74782_a("textureBlock", baseTag);
    }

    public static ItemStack createItemStack(BlockHPChoppingBase table, int amount, ItemStack blockItem) {
        ItemStack stack = new ItemStack(table, amount);
        Block block = Block.func_149634_a(blockItem.func_77973_b());

        if(block != Blocks.field_150350_a) {
            ItemStack blockStack = new ItemStack(block, 1, blockItem.func_77952_i());
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            if (block instanceof BlockHPChoppingBase) {
                subTag = blockItem.func_179543_a("textureBlock");
                subTag = subTag != null ? subTag: new NBTTagCompound();
            } else {
                blockStack.func_77955_b(subTag);
            }
            tag.func_74782_a("textureBlock", subTag);
            stack.func_77982_d(tag);
        }

        return stack;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        List<ItemStack> stacks = Utils.getCraftingItems(this);
        for(ItemStack stack : stacks) {
            if (!Configs.general.useDynamicDisplay && !"minecraft".equals(stack.func_77973_b().getRegistryName().func_110624_b()))
                continue;
            Block block = func_149634_a(stack.func_77973_b());
            int blockMeta = stack.func_77952_i();

            if(blockMeta == OreDictionary.WILDCARD_VALUE) {
                NonNullList<ItemStack> subBlocks = NonNullList.func_191196_a();
                block.func_149666_a(null, subBlocks);

                for(ItemStack subBlock : subBlocks) {
                    list.add(createItemStack(this, 1, subBlock));
                }
            }
            else {
                list.add(createItemStack(this, 1, stack));
            }
        }
    }

    public static IExtendedBlockState getExtendedState(TileEntityHPBase te, IExtendedBlockState state) {
        String side_texture = te.getTileData().func_74779_i("side_texture");
        String top_texture = te.getTileData().func_74779_i("top_texture");

        if (side_texture.isEmpty() || top_texture.isEmpty()) {
            ItemStack stack = new ItemStack(te.getTileData().func_74775_l("textureBlock"));
            if (!stack.func_190926_b() && te.func_145831_w().field_72995_K) {
                Block block = Block.func_149634_a(stack.func_77973_b());
                IBlockState state1 = block.func_176203_a(stack.func_77960_j());
                side_texture = RenderUtils.getTextureFromBlockstate(state1).func_94215_i();
                top_texture = RenderUtils.getTopTextureFromBlockstate(state1).func_94215_i();
                te.getTileData().func_74778_a("side_texture", side_texture);
                te.getTileData().func_74778_a("top_texture", top_texture);
            }
        }

        if (!side_texture.isEmpty())
            state = state.withProperty(SIDE_TEXTURE, side_texture);
        if (!top_texture.isEmpty())
            state = state.withProperty(TOP_TEXTURE, top_texture);

        return state;
    }
}
