/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei.chopping.manual;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChoppingBlock;
import se.gory_moon.horsepower.jei.HorsePowerCategory;
import se.gory_moon.horsepower.jei.HorsePowerPlugin;
import se.gory_moon.horsepower.recipes.ChoppingBlockRecipe;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.Localization;

public class ManualChoppingRecipeWrapper
implements IRecipeWrapper {
    private static List<ItemStack> axes = new ArrayList<ItemStack>();
    private final List<ItemStack> inputs;
    private final ItemStack output;
    private final int time;
    private final IDrawableAnimated arrow;

    public ManualChoppingRecipeWrapper(ChoppingBlockRecipe recipe) {
        this(Collections.singletonList(recipe.getInput()), recipe.getOutput(), recipe.getTime());
    }

    public ManualChoppingRecipeWrapper(List<ItemStack> inputs, ItemStack output, int time) {
        this.inputs = inputs;
        this.output = output;
        this.time = time;
        IGuiHelper guiHelper = HorsePowerPlugin.guiHelper;
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(HorsePowerCategory.COMPONENTS, 60, 0, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 50, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public static void setAxes() {
        axes.clear();
        for (ItemStack stack : HorsePowerPlugin.ingredientRegistry.getAllIngredients(VanillaTypes.ITEM)) {
            if (stack.func_190926_b() || !BlockChoppingBlock.isValidChoppingTool(stack, null)) continue;
            axes.add(stack);
        }
    }

    private int getChoppingAmount() {
        int mult = Configs.recipes.useSeperateChoppingRecipes ? 1 : Configs.general.choppMultiplier;
        return this.time * mult;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputLists = new ArrayList<List<ItemStack>>();
        ArrayList outputLists = new ArrayList();
        inputLists.add(this.inputs);
        inputLists.add(axes);
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(axes.size());
        for (ItemStack stack : axes) {
            ItemStack result = this.output.func_77946_l();
            double base = (double)TileEntityManualChopper.getBaseAmount(stack, null) / 100.0;
            result.func_190920_e((int)Math.ceil((double)result.func_190916_E() * base));
            outputs.add(result);
        }
        outputLists.add(outputs);
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputLists);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 23 && mouseY >= 22 && mouseX < 47 && mouseY < 39) {
            tooltip.add(Localization.GUI.JEI.MANUAL_CHOPPING.translate(this.getChoppingAmount()));
        }
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, 23, 22);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManualChoppingRecipeWrapper)) {
            return false;
        }
        ManualChoppingRecipeWrapper that = (ManualChoppingRecipeWrapper)o;
        boolean flag = true;
        for (ItemStack stack : this.inputs) {
            for (ItemStack stack1 : that.inputs) {
                if (stack1.func_77960_j() != Short.MAX_VALUE || OreDictionary.itemMatches((ItemStack)stack, (ItemStack)stack1, (boolean)false)) continue;
                flag = false;
            }
        }
        return this.time == that.time && flag && this.output.equals(that.output);
    }

    public int hashCode() {
        int result = this.inputs.hashCode() + 1;
        result = 31 * result + this.output.hashCode();
        result = 31 * result + this.time;
        return result;
    }
}

