/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns;

import gory_moon.moarsigns.ConfigHandler;
import gory_moon.moarsigns.blocks.ModBlocks;
import gory_moon.moarsigns.client.interfaces.GuiHandler;
import gory_moon.moarsigns.integration.IntegrationHandler;
import gory_moon.moarsigns.integration.tweaker.MineTweakerIntegration;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.proxy.CommonProxy;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="moarsigns", name="MoarSigns", version="4.2.3.10", certificateFingerprint="5a57c7d1420cf4c58f53ea2a298ebef8215ede63", acceptedMinecraftVersions="[1.10]", guiFactory="gory_moon.moarsigns.client.interfaces.config.GuiFactory", updateJSON="https://raw.githubusercontent.com/GoryMoon/MoarSigns/master/version_promo.json", dependencies="after:BiomesOPlenty;after:forestry;after:natura;after:IC2;after:tconstruct;after:railcraft;after:ThermalFoundation;after:factorization;after:basemetals;after:techreborn;after:Psi;after:roots;after:bigreactors;after:immersiveengineering;after:integrateddynamics;after:draconicevolution;after:EnderIO;after:randomthings;after:JEI@[3.14.0,);after:NotEnoughItems;after:Waila;after:theoneprobe;after:tumat;after:MineTweaker3;")
public class MoarSigns {
    private static final String WAILA_PROVIDER = "gory_moon.moarsigns.integration.waila.Provider.callbackRegister";
    private static final String LINK = "https://raw.githubusercontent.com/GoryMoon/MoarSigns/master/version.json";
    static final String FORGE_PROMO = "https://raw.githubusercontent.com/GoryMoon/MoarSigns/master/version_promo.json";
    @Mod.Instance(value="moarsigns")
    public static MoarSigns instance;
    @SidedProxy(clientSide="gory_moon.moarsigns.proxy.ClientProxy", serverSide="gory_moon.moarsigns.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.instance().loadDefaultConfig(event);
        PacketHandler.init();
        FMLInterModComms.sendMessage((String)"VersionChecker", (String)"addVersionCheck", (String)LINK);
        if (FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)WAILA_PROVIDER)) {
            logger.info("Loaded Waila Integration");
        }
        proxy.preInit();
        ModBlocks.registerTileEntities();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        new IntegrationHandler().setupSigns();
        ModItems.registerRecipes();
        if (Loader.isModLoaded((String)"Quark") || Loader.isModLoaded((String)"quark")) {
            logger.warn("Quark is loaded, MoarSigns sign editing might not work as intended");
        }
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            MineTweakerIntegration.register();
        }
    }

    @Mod.EventHandler
    public void invalidFingerprint(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            FMLLog.bigWarning((String)"%s might not be trustable, the mod has been modified by another party then the author, download a trustable version from CurseForge", (Object[])new Object[]{event.getSource()});
        }
    }

    static {
        logger = LogManager.getLogger((String)"MoarSigns");
    }
}

