/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces.containers;

import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.interfaces.containers.ContainerExchange;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryExchange
implements IInventory {
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)28, (Object)ItemStack.EMPTY);
    public ContainerExchange container;

    public void clearInventory() {
        for (int i = 1; i < this.inventory.size(); ++i) {
            this.setInventorySlotContents(i, ItemStack.EMPTY);
        }
    }

    public void update() {
        ItemStack signStack = (ItemStack)this.inventory.get(0);
        this.clearInventory();
        if (signStack.isEmpty()) {
            return;
        }
        Item item = signStack.getItem();
        if (item instanceof ItemBlock && !((ItemBlock)item).getBlock().equals(Blocks.AIR)) {
            return;
        }
        if (!(item instanceof ItemMoarSign)) {
            return;
        }
        ItemMoarSign cfr_ignored_0 = (ItemMoarSign)item;
        String texture = ItemMoarSign.getTextureFromNBTFull(signStack.getTagCompound());
        SignInfo signInfo = SignRegistry.get(texture);
        if (signInfo == null) {
            return;
        }
        HashSet<MaterialInfo> materials = MaterialRegistry.get(signInfo.material.materialName);
        if (materials == null || materials.size() < 1) {
            return;
        }
        ArrayList<SignInfo> signs = SignRegistry.getSignInfoFromMaterials(materials);
        if (signs.size() < 1) {
            return;
        }
        for (int i = 0; i + 1 < 28 && i < signs.size(); ++i) {
            SignInfo info = signs.get(i);
            this.setInventorySlotContents(i + 1, ModItems.SIGN.createMoarItemStack(info.material.path + info.itemName, info.isMetal));
        }
        this.container.onSlotChanged();
    }

    public int getSizeInventory() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            if (stack.getCount() <= amount) {
                this.setInventorySlotContents(slot, ItemStack.EMPTY);
                return stack;
            }
            if ((stack = stack.splitStack(amount)).getCount() == 0) {
                this.setInventorySlotContents(slot, ItemStack.EMPTY);
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeStackFromSlot(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        this.setInventorySlotContents(slot, ItemStack.EMPTY);
        this.inventory.set(slot, (Object)ItemStack.EMPTY);
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public String getName() {
        return "Exchange Inventory";
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public int getInventoryStackLimit() {
        return 16;
    }

    public void markDirty() {
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        ItemStack held = player.inventory.getStackInSlot(this.container.toolBoxSlot);
        return !held.isEmpty() && held.getItem() instanceof ItemSignToolbox;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return (stack.isEmpty() || !(stack.getItem() instanceof ItemSignToolbox)) && i == this.inventory.size() && !stack.isEmpty() && stack.getItem() instanceof ItemMoarSign;
    }

    public int getField(int id) {
        return id;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        this.inventory.clear();
    }
}

