/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.renderers;

import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.ModelMoarSign;
import gory_moon.moarsigns.client.interfaces.GuiMoarSign;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MoarSignRenderer
extends TileEntitySpecialRenderer {
    private ModelMoarSign modelMoarSign;
    private ResourceLocation tempTexture = new ResourceLocation("textures/entity/sign.png");

    public MoarSignRenderer() {
        this.modelMoarSign = new ModelMoarSign();
    }

    public void renderTileEntityMoarSignAt(TileEntityMoarSign tileentity, double x, double y, double z, float partialTickTime) {
        float f2;
        ResourceLocation texture = tileentity.getResourceLocation();
        Block block = tileentity.getBlockType();
        GL11.glPushMatrix();
        float f1 = 0.6666667f;
        if (!(tileentity.showInGui || block != Blocks.signStandingWood && block != Blocks.signStandingMetal)) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * f1), (float)((float)z + 0.5f));
            float f3 = (float)(tileentity.getBlockMetadata() * 360) / 16.0f;
            GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelMoarSign.stick.showModel = true;
        } else {
            int i = tileentity.getBlockMetadata();
            int side = i & 7;
            f2 = 0.0f;
            boolean flatSign = !tileentity.showInGui && (i & 8) >> 3 == 1;
            boolean groundSign = false;
            if (flatSign) {
                int rotation;
                boolean bl = groundSign = (i & 1) == 1;
                if (groundSign) {
                    rotation = (i & 6) >> 1;
                    f2 = 0.0f;
                    if (rotation == 1) {
                        f2 = 90.0f;
                    } else if (rotation == 2) {
                        f2 = 180.0f;
                    } else if (rotation == 3) {
                        f2 = -90.0f;
                    }
                } else {
                    rotation = (i & 6) >> 1;
                    f2 = 180.0f;
                    if (rotation == 1) {
                        f2 = -90.0f;
                    } else if (rotation == 2) {
                        f2 = 0.0f;
                    } else if (rotation == 3) {
                        f2 = 90.0f;
                    }
                }
            } else {
                if (side == 2) {
                    f2 = 180.0f;
                }
                if (side == 4) {
                    f2 = 90.0f;
                }
                if (side == 5) {
                    f2 = -90.0f;
                }
            }
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * f1), (float)((float)z + 0.5f));
            GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            if (flatSign && !groundSign) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (flatSign && groundSign) {
                GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.modelMoarSign.stick.showModel = false;
        }
        if (texture != null) {
            this.bindTexture(texture);
        } else {
            this.bindTexture(this.tempTexture);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)f1, (float)(-f1), (float)(-f1));
        this.modelMoarSign.render();
        GL11.glPopMatrix();
        FontRenderer fontRenderer = this.func_147498_b();
        int[] sizes = tileentity.rowSizes;
        boolean[] rows = tileentity.visibleRows;
        int[] offset = tileentity.rowLocations;
        for (int row = 0; row < rows.length; ++row) {
            if (!rows[row]) continue;
            float size = sizes[row];
            GL11.glPushMatrix();
            f2 = 0.016666668f * f1 + size / 1000.0f;
            GL11.glTranslatef((float)(size > 0.0f ? 0.01f : 0.0f), (float)(0.5f * f1 - 0.02f * size - (size < 2.0f ? 0.0f : (size < 7.0f ? 0.01f : (size < 11.0f ? 0.02f : (size < 16.0f ? 0.03f : (size < 20.0f ? 0.035f : 0.037f)))))), (float)(0.07f * f1));
            GL11.glScalef((float)f2, (float)(-f2), (float)f2);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f2));
            GL11.glDepthMask((boolean)false);
            int maxLength = Utils.getMaxLength((int)size) - GuiMoarSign.toPixelWidth(fontRenderer, GuiMoarSign.getStyleOffset(tileentity.signText[row], tileentity.shadowRows[row]));
            String s = fontRenderer.trimStringToWidth(tileentity.signText[row], Math.min(maxLength, fontRenderer.getStringWidth(tileentity.signText[row])));
            GL11.glDisable((int)2896);
            fontRenderer.drawString(s, -fontRenderer.getStringWidth(s) / 2, -tileentity.signText.length * 5 + offset[row] - 2, 0, tileentity.shadowRows[row]);
            GL11.glEnable((int)2896);
            GL11.glDepthMask((boolean)true);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float partialTickTime) {
        this.renderTileEntityMoarSignAt((TileEntityMoarSign)tileentity, x, y, z, partialTickTime);
    }
}

