/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.tileentites;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignMainInfo;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;

public class TileEntityMoarSign
extends TileEntitySign {
    public static final String NBT_VERSION_TAG = "nbtVersion";
    public static final String NBT_SETTINGS_TAG = "settings";
    public static final String NBT_LOCKED_CHANGES_TAG = "lockedChanges";
    public static final String NBT_METAL_TAG = "isMetal";
    public static final String NBT_TEXTURE_TAG = "texture";
    private final int NBT_VERSION = 2;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public boolean isMetal = false;
    public String texture_name;
    public boolean showInGui = false;
    public boolean removeNoDrop;
    private boolean isEditable = true;
    private EntityPlayer playerEditing;
    private ResourceLocation resourceLocation;
    private boolean textureReq = false;

    public TileEntityMoarSign() {
        for (int i = 0; i < 4; ++i) {
            this.rowLocations[i] = 2 + 10 * i;
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            SignInfo sign;
            if (!this.textureReq) {
                this.textureReq = true;
                Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, block, 0, 0);
            }
            if ((sign = SignRegistry.get(this.texture_name)) != null && sign.property != null) {
                sign.property.onUpdate();
            }
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a(NBT_VERSION_TAG, 2);
        for (int i = 0; i < 4; ++i) {
            compound.func_74778_a("Text" + (i + 1), this.field_145915_a[i]);
        }
        NBTTagList settings = new NBTTagList();
        int[] loc = new int[5];
        loc[0] = 0;
        System.arraycopy(this.rowLocations, 0, loc, 1, 4);
        int[] size = new int[5];
        size[0] = 1;
        System.arraycopy(this.rowSizes, 0, size, 1, 4);
        int[] visible = new int[5];
        visible[0] = 2;
        for (int i = 0; i < 4; ++i) {
            visible[i + 1] = this.visibleRows[i] ? 1 : 0;
        }
        int[] shadow = new int[5];
        shadow[0] = 3;
        for (int i = 0; i < 4; ++i) {
            shadow[i + 1] = this.shadowRows[i] ? 1 : 0;
        }
        NBTTagIntArray locations = new NBTTagIntArray(loc);
        NBTTagIntArray sizes = new NBTTagIntArray(size);
        NBTTagIntArray hidden = new NBTTagIntArray(visible);
        NBTTagIntArray shadows = new NBTTagIntArray(shadow);
        settings.func_74742_a((NBTBase)locations);
        settings.func_74742_a((NBTBase)sizes);
        settings.func_74742_a((NBTBase)hidden);
        settings.func_74742_a((NBTBase)shadows);
        compound.func_74782_a(NBT_SETTINGS_TAG, (NBTBase)settings);
        compound.func_74757_a(NBT_LOCKED_CHANGES_TAG, this.lockedChanges);
        compound.func_74757_a(NBT_METAL_TAG, this.isMetal);
        if (this.texture_name != null) {
            compound.func_74778_a(NBT_TEXTURE_TAG, this.texture_name);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int nbtVersion = compound.func_74762_e(NBT_VERSION_TAG);
        if (nbtVersion == 1) {
            int i;
            int fontSize = compound.func_74762_e("fontSize");
            int rows = Utils.getRows(fontSize);
            this.rowSizes = new int[]{fontSize, fontSize, fontSize, fontSize};
            this.visibleRows = new boolean[]{false, false, false, false};
            for (i = 0; i < rows; ++i) {
                this.visibleRows[i] = true;
            }
            for (i = 0; i < 4; ++i) {
                this.field_145915_a[i] = compound.func_74779_i("Text" + (i + 1));
                if (i <= rows) continue;
                this.field_145915_a[i] = "";
            }
            int textOffset = compound.func_74762_e("textOffset");
            for (int i2 = 0; i2 < 4; ++i2) {
                int temp = Math.abs(textOffset) + this.rowLocations[i2] - (textOffset != 0 ? 2 : 0);
                if (temp < 0) {
                    temp = 0;
                }
                this.rowLocations[i2] = temp;
            }
        } else if (nbtVersion == 2) {
            int i;
            this.lockedChanges = compound.func_74767_n(NBT_LOCKED_CHANGES_TAG);
            NBTTagList settings = compound.func_150295_c(NBT_SETTINGS_TAG, 11);
            for (i = 0; i < settings.func_74745_c(); ++i) {
                int j;
                int[] array = settings.func_150306_c(i);
                if (array[0] == 0) {
                    System.arraycopy(array, 1, this.rowLocations, 0, 4);
                    continue;
                }
                if (array[0] == 1) {
                    System.arraycopy(array, 1, this.rowSizes, 0, 4);
                    continue;
                }
                if (array[0] == 2) {
                    int[] hidden = new int[4];
                    System.arraycopy(array, 1, hidden, 0, 4);
                    for (j = 0; j < 4; ++j) {
                        this.visibleRows[j] = hidden[j] == 1;
                    }
                    continue;
                }
                if (array[0] != 3) continue;
                int[] shadows = new int[4];
                System.arraycopy(array, 1, shadows, 0, 4);
                for (j = 0; j < 4; ++j) {
                    this.shadowRows[j] = shadows[j] == 1;
                }
            }
            for (i = 0; i < 4; ++i) {
                this.field_145915_a[i] = compound.func_74779_i("Text" + (i + 1));
            }
        }
        if (compound.func_74764_b(NBT_METAL_TAG)) {
            this.isMetal = compound.func_74767_n(NBT_METAL_TAG);
        }
        if (compound.func_74764_b(NBT_TEXTURE_TAG)) {
            this.texture_name = compound.func_74779_i(NBT_TEXTURE_TAG);
        }
        if (this.texture_name == null || this.texture_name.isEmpty()) {
            this.texture_name = "oak_sign";
        }
    }

    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageSignMainInfo(this));
    }

    public boolean func_145914_a() {
        return this.isEditable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145913_a(boolean state) {
        this.isEditable = state;
        if (!state) {
            this.playerEditing = null;
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String texture) {
        if (!this.field_145850_b.field_72995_K) {
            this.texture_name = texture;
        } else if (this.resourceLocation == null) {
            this.texture_name = texture;
            this.resourceLocation = MoarSigns.instance.getResourceLocation(texture, this.isMetal);
        }
    }

    public void func_145912_a(EntityPlayer par1EntityPlayer) {
        this.playerEditing = par1EntityPlayer;
    }

    public EntityPlayer func_145911_b() {
        return this.playerEditing;
    }
}

