/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemMoarSign
extends Item {
    public ItemMoarSign() {
        this.maxStackSize = 16;
        this.setCreativeTab(MoarSignsCreativeTab.tabMS);
        this.setUnlocalizedName("moarsigns");
        this.hasSubtypes = true;
    }

    public static String getTextureFromNBTFull(NBTTagCompound compound) {
        return compound != null && compound.hasKey("SignTexture") ? compound.getString("SignTexture") : "";
    }

    public static String getTextureFromNBT(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        if (texture.contains("\\")) {
            texture = texture.split("\\\\")[1];
        }
        if (texture.contains("/")) {
            texture = texture.split("/")[1];
        }
        return texture;
    }

    public static SignInfo getInfo(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        return SignRegistry.get(texture);
    }

    public String getUnlocalizedName(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound()));
        if (info == null) {
            return super.getUnlocalizedName() + ".sign.error";
        }
        return super.getUnlocalizedName() + ".sign." + (info.material.path.equals("") ? "" : info.material.path.replace("/", "") + ".") + ItemMoarSign.getTextureFromNBT(stack.getTagCompound());
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        this.getSubItemStacks(list);
    }

    public void getSubItemStacks(List list) {
        ArrayList<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();
        for (SignInfo info : signRegistry) {
            list.add(this.createMoarItemStack(info.material.path + info.itemName, info.isMetal));
        }
    }

    public EnumRarity getRarity(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound()));
        if (info != null) {
            return info.rarity;
        }
        return EnumRarity.COMMON;
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack((Item)this, 1, isMetal ? 1 : 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("SignTexture", signName.replace("\\", "/"));
        itemStack.setTagCompound(compound);
        return itemStack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.getBlockState(pos).getBlock().getMaterial().isSolid()) {
            return false;
        }
        if (!player.canPlayerEdit(pos = pos.offset(side), side, stack) || !Blocks.signStandingWood.canPlaceBlockAt(world, pos)) {
            return false;
        }
        if (world.isRemote) {
            return true;
        }
        SignInfo info = ItemMoarSign.getInfo(stack.getTagCompound());
        if (info == null) {
            return false;
        }
        if (side == EnumFacing.UP && !player.isSneaking()) {
            int rotation = MathHelper.floor_double((double)((double)((player.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            if (!info.isMetal) {
                world.setBlockState(pos, Blocks.signStandingWood.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(rotation)), 3);
            } else {
                world.setBlockState(pos, Blocks.signStandingMetal.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(rotation)), 3);
            }
        } else {
            int finalRotation = side.getIndex();
            if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                int rotation = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                finalRotation += rotation << 1;
                finalRotation += 8;
            }
            if (!info.isMetal) {
                world.setBlockState(pos, Blocks.signWallWood.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(finalRotation)), 3);
            } else {
                world.setBlockState(pos, Blocks.signWallMetal.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(finalRotation)), 3);
            }
        }
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        if ((tileEntity = world.getTileEntity(pos)) instanceof TileEntityMoarSign && !ItemBlock.setTileEntityNBT((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack)) {
            TileEntityMoarSign te = (TileEntityMoarSign)tileEntity;
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound());
            te.isMetal = info.isMetal;
            te.setPlayer(player);
            te.setResourceLocation(texture);
            boolean moving = stack.getTagCompound().hasKey("SignMoving") && stack.getTagCompound().getBoolean("SignMoving");
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(te, moving), (EntityPlayerMP)player);
        }
        return true;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
        SignInfo info = ItemMoarSign.getInfo(stack.getTagCompound());
        if (info != null) {
            String modName = info.activateTag.equals("activeALL") ? "Minecraft" : info.activateTag;
            list.add(Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate((Object)((Object)Colors.WHITE) + Utils.getModName(modName)));
            if (extraInfo) {
                list.add(Localization.ITEM.SIGN.MATERIAL.translate((Object)((Object)Colors.WHITE) + info.material.materialName));
            }
        } else {
            list.add((Object)((Object)Colors.RED) + Localization.ITEM.SIGN.ERROR.translate(Colors.RED.toString()));
        }
    }
}

