package gory_moon.moarsigns.integration.nei;

import codechicken.nei.ItemList;
import codechicken.nei.api.stack.PositionedStack;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.util.NEIServerUtils;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe.MatchType;
import gory_moon.moarsigns.api.ShapelessMoarSignRecipe;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.items.ItemMoarSign;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.translation.I18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import static gory_moon.moarsigns.integration.nei.NEIMoarSignConfig.moarSigns;

import codechicken.nei.recipe.ShapelessRecipeHandler.CachedShapelessRecipe;

public class NEIShapelessMoarSignHandler extends ShapelessRecipeHandler {
    @Override
    @SuppressWarnings("unchecked")
    public void loadCraftingRecipes(String outputId, Object... results) {
        if (outputId.equals("crafting") && getClass() == NEIShapelessMoarSignHandler.class) {
            List<IRecipe> allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe iRecipe : allrecipes) {
                CachedMoarSignRecipe recipe = null;
                if (iRecipe instanceof ShapelessMoarSignRecipe)
                    recipe = forgeShapelessRecipe((ShapelessMoarSignRecipe) iRecipe);

                if (recipe == null)
                    continue;

                arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void loadCraftingRecipes(ItemStack result) {
        List<IRecipe> allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe iRecipe : allrecipes) {
            if (NEIServerUtils.areStacksSameTypeCrafting(iRecipe.func_77571_b(), result)) {
                CachedMoarSignRecipe recipe = null;
                if (iRecipe instanceof ShapelessMoarSignRecipe)
                    recipe = forgeShapelessRecipe((ShapelessMoarSignRecipe) iRecipe);

                if (recipe == null)
                    continue;

                if (((ShapelessMoarSignRecipe) iRecipe).isNeiNBTDifferent() && !ItemStack.func_77970_a(recipe.result.item, result))
                    continue;

                arecipes.add(recipe);
            }
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void loadUsageRecipes(ItemStack ingredient) {
        List<IRecipe> allIRecipes = (List<IRecipe>) CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe iRecipe : allIRecipes) {
            CachedMoarSignRecipe recipe = null;
            if (iRecipe instanceof ShapelessMoarSignRecipe)
                recipe = forgeShapelessRecipe((ShapelessMoarSignRecipe) iRecipe);

            if (recipe == null)
                continue;

            if (recipe.contains(recipe.ingredients, ingredient)) {
                recipe.setIngredientPermutation(recipe.ingredients, ingredient);
                arecipes.add(recipe);
            }

        }
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        for (ItemStack stack : ItemList.items) {
            if (stack != null && stack.func_77973_b() instanceof ItemMoarSign) {
                moarSigns.add(stack);
            }
        }

        return super.newInstance();
    }

    private CachedMoarSignRecipe forgeShapelessRecipe(ShapelessMoarSignRecipe recipe) {
        ArrayList<Object> items = recipe.getInput();

        for (Object item : items)
            if (item instanceof List && ((List<?>) item).isEmpty())
                return null;

        return new CachedMoarSignRecipe(items, recipe.func_77571_b());
    }

    @Override
    public String getRecipeName() {
        return I18n.func_74838_a("crafting.moarsigns.sign.shapeless");
    }

    public class CachedMoarSignRecipe extends CachedShapelessRecipe {

        public CachedMoarSignRecipe(ArrayList<Object> items, ItemStack recipeOutput) {
            super(items, recipeOutput);
        }

        @Override
        public void setIngredients(List<?> items) {
            ingredients.clear();
            for (int ingred = 0; ingred < items.size(); ingred++) {
                Object o = items.get(ingred);
                if (o instanceof ItemStack) {
                    PositionedStack stack = new PositionedStack(items.get(ingred), 25 + stackorder[ingred][0] * 18, 6 + stackorder[ingred][1] * 18);
                    stack.setMaxSize(1);
                    ingredients.add(stack);
                } else if (o instanceof MatchType || o instanceof MaterialInfo) {
                    ArrayList<ItemStack> signs = new ArrayList<ItemStack>();
                    for (ItemStack stack : moarSigns) {
                        SignInfo info = ItemMoarSign.getInfo(stack.func_77978_p());

                        if (o instanceof MatchType) {
                            if (o == MatchType.ALL) {
                                signs.add(stack);
                            } else if (o == MatchType.METAL && info.isMetal) {
                                signs.add(stack);
                            } else if (o == MatchType.WOOD && !info.isMetal) {
                                signs.add(stack);
                            }
                        } else if (((MaterialInfo) o).materialName.equals(info.material.materialName)) {
                            signs.add(stack);
                        }
                    }

                    PositionedStack stack = new PositionedStack(signs, 25 + stackorder[ingred][0] * 18, 6 + stackorder[ingred][1] * 18);
                    stack.setMaxSize(1);
                    ingredients.add(stack);
                } else if (o instanceof List) {
                    PositionedStack stack = new PositionedStack(o, 25 + stackorder[ingred][0] * 18, 6 + stackorder[ingred][1] * 18);
                    stack.setMaxSize(1);
                    ingredients.add(stack);
                }
            }
        }

        @Override
        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            Iterator i$ = ingredients.iterator();

            PositionedStack stack;
            do {
                if (!i$.hasNext()) {
                    return false;
                }

                stack = (PositionedStack) i$.next();
            } while (!stackContains(stack, ingredient));

            return true;
        }

        private boolean stackContains(PositionedStack stack, ItemStack ingredient) {
            ItemStack[] arr$ = stack.items;

            for (ItemStack item : arr$) {
                if (ItemStack.func_77970_a(item, ingredient) && ingredient.func_77969_a(item)) {
                    return true;
                }
            }

            return false;
        }
    }
}
