/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.vctweaker.asm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import se.gory_moon.vctweaker.util.Log;

public class VCTransformer
implements IClassTransformer,
Opcodes {
    private static Map<String, ClassName> classMap = new HashMap<String, ClassName>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassName clazz = classMap.get(name);
        if (clazz != null) {
            basicClass = clazz.transform(basicClass);
            classMap.remove(name);
        }
        return basicClass;
    }

    static {
        for (ClassName className : ClassName.values()) {
            classMap.put(className.getName(), className);
        }
    }

    private static enum ClassName {
        GUI_WORKBENCH("com.viesis.viescraft.client.gui.GuiTileEntityAirshipWorkbench", Transformer.FIX_NO_GUI_TOOLTIP, Transformer.REMOVE_WORKBENCH_R_CLOSING),
        GUI_AIRSHIP_MENU("com.viesis.viescraft.client.gui.airship.main.GuiAirshipMenu", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_UPGRADE("com.viesis.viescraft.client.gui.airship.main.GuiUpgradeMenu", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_VISUAL("com.viesis.viescraft.client.gui.airship.main.GuiVisualMenu", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_MODULE("com.viesis.viescraft.client.gui.airship.main.GuiModuleMenu", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_MODULE_INV("com.viesis.viescraft.client.gui.airship.main.GuiAirshipMenuStorageNormal", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_MODULE_INV_SMALL("com.viesis.viescraft.client.gui.airship.main.GuiAirshipMenuStorageLesser", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_MODULE_INV_LARGE("com.viesis.viescraft.client.gui.airship.main.GuiAirshipMenuStorageGreater", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_MUSIC("com.viesis.viescraft.client.gui.airship.main.GuiAirshipMenuMusic", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_MUSIC_1("com.viesis.viescraft.client.gui.airship.music.GuiAirshipMusicPg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_BALLOON("com.viesis.viescraft.client.gui.airship.visual.balloon.GuiVisualMenuBalloon", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_BALLOON_COLOR("com.viesis.viescraft.client.gui.airship.visual.balloon.GuiVisualMenuBalloonColor", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_BALLOON_T1("com.viesis.viescraft.client.gui.airship.visual.balloon.GuiVisualMenuBalloonTier1Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_BALLOON_T2("com.viesis.viescraft.client.gui.airship.visual.balloon.GuiVisualMenuBalloonTier2Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_BALLOON_T3("com.viesis.viescraft.client.gui.airship.visual.balloon.GuiVisualMenuBalloonTier3Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_BALLOON_T4("com.viesis.viescraft.client.gui.airship.visual.balloon.GuiVisualMenuBalloonTier4Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_BALLOON_T5("com.viesis.viescraft.client.gui.airship.visual.balloon.GuiVisualMenuBalloonTier5Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrame", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME_COLOR("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrameColor", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME_T1("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrameTier1Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME_T1P2("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrameTier1Pg2", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME_T2("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrameTier2Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME_T3("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrameTier3Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME_T4("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrameTier4Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        GUI_AIRSHIP_FRAME_T5("com.viesis.viescraft.client.gui.airship.visual.frame.GuiVisualMenuFrameTier51Pg1", Transformer.FIX_NO_GUI_TOOLTIP),
        AIRSHIP_V1("com.viesis.viescraft.common.entity.airshipcolors.EntityAirshipV1Core", Transformer.REPLACE_FUELHANDLING),
        AIRSHIP_V2("com.viesis.viescraft.common.entity.airshipcolors.EntityAirshipV2Core", Transformer.REPLACE_FUELHANDLING),
        AIRSHIP_V3("com.viesis.viescraft.common.entity.airshipcolors.EntityAirshipV3Core", Transformer.REPLACE_FUELHANDLING),
        AIRSHIP_V4("com.viesis.viescraft.common.entity.airshipcolors.EntityAirshipV4Core", Transformer.REPLACE_FUELHANDLING),
        AIRSHIP_V5("com.viesis.viescraft.common.entity.airshipcolors.EntityAirshipV5Core", Transformer.REPLACE_FUELHANDLING),
        AIRSHIP_V6("com.viesis.viescraft.common.entity.airshipcolors.EntityAirshipV6Core", Transformer.REPLACE_FUELHANDLING);

        private String name;
        private Transformer[] transformers;

        private ClassName(String name, Transformer ... transformers) {
            this.name = name;
            this.transformers = transformers;
        }

        public String getName() {
            return this.name;
        }

        public Transformer[] getTransformers() {
            return this.transformers;
        }

        public byte[] transform(byte[] bytes) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            Log.info("Applying Transformer" + (this.transformers.length > 1 ? "s " : " ") + "to " + this.getName(), new Object[0]);
            for (Transformer transformer : this.getTransformers()) {
                transformer.transform(classNode);
            }
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
    }

    private static enum Transformer {
        REPLACE_JEI("register", "(Lmezz/jei/api/IModRegistry;)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                AbstractInsnNode node = list.getFirst();
                while (node.getOpcode() != 25) {
                    node = node.getNext();
                }
                LabelNode label1 = new LabelNode();
                list.insertBefore(node, (AbstractInsnNode)new FieldInsnNode(178, "se/gory_moon/vctweaker/VCTweakerContainer$Configs", "replaceJEI", "Z"));
                list.insertBefore(node, (AbstractInsnNode)new JumpInsnNode(154, label1));
                list.insertBefore(node, (AbstractInsnNode)new LabelNode());
                while (node.getOpcode() != 83) {
                    node = node.getNext();
                }
                while (node.getOpcode() != 25) {
                    node = node.getNext();
                }
                list.insertBefore(node, (AbstractInsnNode)label1);
                list.insertBefore(node, (AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
                while (node.getOpcode() != 25 || ((VarInsnNode)node).var != 3) {
                    node = node.getNext();
                }
                LabelNode label2 = new LabelNode();
                list.insertBefore(node, (AbstractInsnNode)new FieldInsnNode(178, "se/gory_moon/vctweaker/VCTweakerContainer$Configs", "replaceJEI", "Z"));
                list.insertBefore(node, (AbstractInsnNode)new JumpInsnNode(154, label2));
                list.insertBefore(node, (AbstractInsnNode)new LabelNode());
                while (node.getOpcode() != 177) {
                    node = node.getNext();
                }
                list.insertBefore(node, (AbstractInsnNode)label2);
                list.insertBefore(node, (AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
                return list;
            }
        }
        ,
        REMOVE_WORKBENCH_R_CLOSING(FMLForgePlugin.RUNTIME_DEOBF ? "func_73869_a" : "keyTyped", "(CI)V"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                AbstractInsnNode node = list.getFirst();
                AbstractInsnNode base = list.getFirst();
                while (node.getOpcode() != 159) {
                    node = node.getNext();
                    base = base.getNext();
                }
                node = node.getNext();
                while (node.getOpcode() != 25) {
                    list.remove(node);
                    node = base.getNext();
                }
                return list;
            }
        }
        ,
        FIX_NO_GUI_TOOLTIP(FMLForgePlugin.RUNTIME_DEOBF ? "func_73863_a" : "drawScreen", "(IIF)V", TransformType.METHOD, TransformType.ADD){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                list.add((AbstractInsnNode)new LabelNode());
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "se/gory_moon/vctweaker/asm/VCHooks", "drawDefaultBack", "(Lnet/minecraft/client/gui/inventory/GuiContainer;)V", false));
                list.add((AbstractInsnNode)new LabelNode());
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(21, 1));
                list.add((AbstractInsnNode)new VarInsnNode(21, 2));
                list.add((AbstractInsnNode)new VarInsnNode(23, 3));
                list.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/client/gui/inventory/GuiContainer", FMLForgePlugin.RUNTIME_DEOBF ? "func_73863_a" : "drawScreen", "(IIF)V", false));
                list.add((AbstractInsnNode)new LabelNode());
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(21, 1));
                list.add((AbstractInsnNode)new VarInsnNode(21, 2));
                list.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/client/gui/inventory/GuiContainer", FMLForgePlugin.RUNTIME_DEOBF ? "func_191948_b" : "renderHoveredToolTip", "(II)V", false));
                list.add((AbstractInsnNode)new LabelNode());
                list.add((AbstractInsnNode)new InsnNode(177));
                list.add((AbstractInsnNode)new LabelNode());
                return list;
            }
        }
        ,
        REPLACE_FUELHANDLING("getItemBurnTime", "(Lnet/minecraft/item/ItemStack;)I"){

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                list.clear();
                list.add((AbstractInsnNode)new LabelNode());
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "se/gory_moon/vctweaker/fuel/FuelHandler", "getItemBurnTime", "(Lnet/minecraft/item/ItemStack;)I", false));
                list.add((AbstractInsnNode)new InsnNode(172));
                list.add((AbstractInsnNode)new LabelNode());
                return list;
            }
        }
        ,
        PRINT("drawScreen", "(IIF)V"){
            private Printer printer;
            private TraceMethodVisitor mp;

            public String insnToString(AbstractInsnNode insn) {
                insn.accept((MethodVisitor)this.mp);
                StringWriter sw = new StringWriter();
                this.printer.print(new PrintWriter(sw));
                this.printer.getText().clear();
                return sw.toString();
            }

            @Override
            protected InsnList modifyInstructions(InsnList list) {
                this.printer = new Textifier();
                this.mp = new TraceMethodVisitor(this.printer);
                boolean printCompact = true;
                for (int i = 0; i < list.size(); ++i) {
                    if (printCompact) {
                        System.out.print(this.insnToString(list.get(i)));
                        continue;
                    }
                    Log.info(String.valueOf(list.get(i)), new Object[0]);
                    Log.info(this.insnToString(list.get(i)), new Object[0]);
                }
                return super.modifyInstructions(list);
            }
        };

        protected String name;
        protected String args;
        protected TransformType type;
        protected TransformType action;

        private Transformer(String name) {
            this(name, "", TransformType.INNER_CLASS, TransformType.MAKE_PUBLIC);
        }

        private Transformer(String name, String args) {
            this(name, args, TransformType.METHOD, TransformType.MODIFY);
        }

        private Transformer(String name, String args, TransformType type, TransformType action) {
            this.name = name;
            this.args = args;
            this.type = type;
            this.action = action;
        }

        protected InsnList modifyInstructions(InsnList list) {
            return list;
        }

        private static InsnList replace(InsnList list, String toReplace, String replace) {
            InsnList result = new InsnList();
            for (AbstractInsnNode node = list.getFirst(); node != null; node = node.getNext()) {
                result.add(Transformer.checkReplace(node, toReplace, replace));
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public String getArgs() {
            return this.args;
        }

        protected void methodTransform(ClassNode node) {
            MethodNode methodNode = this.getMethod(node);
            if (methodNode == null && this.action == TransformType.ADD) {
                methodNode = new MethodNode(262144, 1, this.name, this.args, null, null);
                node.methods.add(methodNode);
            }
            if (methodNode != null) {
                switch (this.action) {
                    case ADD: 
                    case MODIFY: {
                        methodNode.instructions = this.modifyInstructions(methodNode.instructions);
                        break;
                    }
                    case DELETE: {
                        node.methods.remove(methodNode);
                        break;
                    }
                    case MAKE_PUBLIC: {
                        methodNode.access = methodNode.access & 0xFFFFFFF8 ^ 1;
                    }
                }
                this.complete();
            }
        }

        private void fieldTransform(ClassNode node) {
            FieldNode fieldNode = this.getField(node);
            if (fieldNode != null) {
                switch (this.action) {
                    case MODIFY: {
                        this.modifyField(fieldNode);
                        break;
                    }
                    case DELETE: {
                        node.fields.remove(fieldNode);
                        break;
                    }
                    case MAKE_PUBLIC: {
                        fieldNode.access = fieldNode.access & 0xFFFFFFF8 ^ 1;
                    }
                }
                this.complete();
            }
        }

        private void modifyField(FieldNode fieldNode) {
        }

        private void innerClassTransform(ClassNode node) {
            InnerClassNode innerClassNode = this.getInnerClass(node);
            if (innerClassNode != null) {
                switch (this.action) {
                    case MODIFY: {
                        this.modifyInnerClass(innerClassNode);
                        break;
                    }
                    case DELETE: {
                        node.innerClasses.remove(innerClassNode);
                        break;
                    }
                    case MAKE_PUBLIC: {
                        innerClassNode.access = innerClassNode.access & 0xFFFFFFF8 ^ 1;
                    }
                }
                this.complete();
            }
        }

        private void modifyInnerClass(InnerClassNode innerClassNode) {
        }

        public void transform(ClassNode node) {
            switch (this.type) {
                case METHOD: {
                    this.methodTransform(node);
                    return;
                }
                case FIELD: {
                    this.fieldTransform(node);
                    return;
                }
                case INNER_CLASS: {
                    this.innerClassTransform(node);
                }
            }
        }

        private static AbstractInsnNode checkReplace(AbstractInsnNode node, String toReplace, String replace) {
            if (node instanceof TypeInsnNode && ((TypeInsnNode)node).desc.equals(toReplace)) {
                return new TypeInsnNode(187, replace);
            }
            if (node instanceof MethodInsnNode && ((MethodInsnNode)node).owner.contains(toReplace)) {
                return new MethodInsnNode(node.getOpcode(), replace, ((MethodInsnNode)node).name, ((MethodInsnNode)node).desc, false);
            }
            return node;
        }

        public void complete() {
            Log.info("Applied " + (Object)((Object)this) + " transformer", new Object[0]);
        }

        public MethodNode getMethod(ClassNode classNode) {
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals(this.getName()) || !method.desc.equals(this.getArgs())) continue;
                return method;
            }
            for (MethodNode method : classNode.methods) {
                if (!method.desc.equals(this.getArgs())) continue;
                return method;
            }
            return null;
        }

        public FieldNode getField(ClassNode classNode) {
            for (FieldNode field : classNode.fields) {
                if (!field.name.equals(this.getName()) || !field.desc.equals(this.getArgs())) continue;
                return field;
            }
            return null;
        }

        public InnerClassNode getInnerClass(ClassNode classNode) {
            String name = classNode.name + "$" + this.getName();
            for (InnerClassNode inner : classNode.innerClasses) {
                if (!name.equals(inner.name)) continue;
                return inner;
            }
            return null;
        }
    }

    private static enum TransformType {
        METHOD,
        FIELD,
        INNER_CLASS,
        MODIFY,
        MAKE_PUBLIC,
        DELETE,
        ADD;

    }
}

